% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogVeroFuncBUENA.R
\name{LogVeroFuncBUENA}
\alias{LogVeroFuncBUENA}
\title{Writting the loglikelihood of the dirichlet}
\usage{
LogVeroFuncBUENA(param, MatrizPBmodelo, E, Tt, especiemodi)
}
\arguments{
\item{param}{Vector. Column "mean" of the output of "StudyingParam" function.}

\item{MatrizPBmodelo}{Matrix with the covariates of the model. In an example with two SPBal and three time points, the covariates are written in the following  order:
\tabular{rrr}{
1 \tab  1  \tab  1\cr
\eqn{SPBal_{1,t-1}} \tab  \eqn{SPBal_{1,t-2}} \tab   \eqn{SPBal_{1,t-3}} \cr
\eqn{SPBal_{2,t-1}} \tab  \eqn{SPBal_{2,t-2}} \tab  \eqn{ SPBal_{2,t-3}} }}

\item{E}{Number f bacteria in the dataset.}

\item{Tt}{Number of time points available}

\item{especiemodi}{Matrix that contains at row i the bacterial taxa of bacteria i at time points t=2,...,\code{Tt}.}
}
\value{
Returns a number with the value of the dirichlet loglikelihood.
}
\description{
This function calculates the loglikelihood of the dirichlet for the BPBM model.
}
\examples{


set.seed(314)
especie=t(gtools::rdirichlet(n=2, c(1,2,3)))
E=3
Tt=2
MatrizPBmodelo=rbind(c(1,1),c(-0.3,0.4),c(0.3,0.5))
set.seed(314)
est=Estimating_BPBM(especie,
                   Tt,
                   E,
                   MatrizPBmodelo,
                   nn.chain=3,
                   nn.burnin=1000,
                   nn.sample=5000,
                   nn.thin=10)

param=est$SamplesAllChains

especiemodi=especie[,-1]


LogVeroFuncBUENA(param,MatrizPBmodelo,E,Tt,especiemodi)
}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2022). Bayesian hierarchical compositional models for analysing longitudinal abundance data from microbiome studies. Complexity, 2022.
}
