% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableBPBM.R
\name{TableBPBM}
\alias{TableBPBM}
\title{Obtaining a table with the SPBal information of the BPBM}
\usage{
TableBPBM(
  NumSPBal,
  DemSPBal,
  PerVar,
  MatrizPBmodelo,
  Estimated.Param,
  BB = 0.55,
  names,
  E
)
}
\arguments{
\item{NumSPBal}{List. Output of "ObtainigValueSPBal" function.List. The component i of the list has the number of the row of the matrix \code{especie} where the bacteria in the numerator of the selected  principal balance i are placed.}

\item{DemSPBal}{List. Output of "ObtainigValueSPBal" function.List. The component i of the list has the number of the row of the matrix \code{especie} where the bacteria in the denominator of the selected  principal balance i are placed.}

\item{PerVar}{Vector. Output of "ObtainigValueSPBal" function. The component of the vector i contains the percentage of variance of the SPBal with numerator \code{NumSPBal[[i]]} and denominator \code{DemSPBal[[i]]}.}

\item{MatrizPBmodelo}{Matrix. Output of "ObtainigValueSPBal" function.  MatrixSPBal is the matrix that contains the covariates of the model. The first line es equal to 1 for all columns. The other rows contain the value of one SPBal at all time points. The selected principal balance of the row i+1 has at its numerator the bacteria placed in the rows \code{NumSPBal[[i]]} of the "especie". The selected principal balance of the row i+1 has at its denominator the bacteria placed in the rows \code{DemSPBal[[i]]} of the "especie".}

\item{Estimated.Param}{Vector. Column "mean" of the output of StudyingParam function.}

\item{BB}{The bacteria in the numerator and the denominator of the balance are considered similar if the mean of the SPBal is between (-BB,BB).Default: 0.55.}

\item{names}{Vector with the bacteria's names placed in the order in which appear in the rows of the matrices \code{especie} and \code{especiemodi}.}

\item{E}{number of bacteria in the dataset.}
}
\value{
Returns the table written in latex
}
\description{
Returns a table with the percentage of variance that each SPBal has, the bacteria that goes in the numerator and denominator of the balance, the relationship between the group in the numerator and the denominator and the bacteria most influenced by this SPBal.
}
\examples{
NumSPBal=list(c(3,4),3,2)
DemSPBal=list(1,5,4)
PerVar=c(41.37487, 21.08270, 19.16870)
MatrizPBmodelo=rbind(c(1.00000000,  1.0000000,  1.0000000,  1.0000000 , 1.0000000),
                    c(1.84449081, -1.3569851, -0.1388348, -0.5269079, -1.3288684),
                    c(0.27531685,  0.4741394, -1.9045554, -0.3581268, -0.4768543),
                    c( 0.07782991,  0.3492473, -0.7138882,  1.4332828, -0.7203295))
namesOr=c("Bact1", "Bact2","Bact3","Bact4","Bact5")
Estimated.Param=c(0.5, 0.3, -0.2,0.1)
E=5

TableBPBM(NumSPBal,
         DemSPBal,
         PerVar,
         MatrizPBmodelo,
         Estimated.Param,
         BB=0.55,
         namesOr,
         E)

}
