% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_generic.R
\name{fit.pdf.mcmc}
\alias{fit.pdf.mcmc}
\title{Posterior mean density plot for dose intervals}
\usage{
fit.pdf.mcmc(y, x, fit, mcmc, J=10, H = 10, alpha = 0.05, 
max.x = max(x), x.val, y.grid = NULL, xlim = c(0, max(x)), 
ylim = c(0, 1), xlab = NULL)
}
\arguments{
\item{y}{optional numeric vector for the response used in \code{comire.gibbs}. If \code{y} is missing, \code{y.grid} must be provided.}

\item{x}{numeric vector for the covariate relative to the dose of exposure used in \code{comire.gibbs}.}

\item{fit}{the output of \code{comire.gibbs} opportunely trasformed in \code{classCoMiRe} class.}

\item{mcmc}{a list giving the MCMC parameters.}

\item{J}{parameter controlling the number of elements of the I-spline basis}

\item{H}{total number of components in the mixture at \eqn{x_0}.}

\item{alpha}{level of the credible bands.}

\item{max.x}{maximum value allowed for x.}

\item{x.val}{central points of each dose interval to be used in the posterior estimation of the probability density function.}

\item{y.grid}{optional numerical vector giving the actual values of the grid for y for plotting the posterior mean density. If \code{y.grid} is not provided, standard grids are automatically used.}

\item{xlim, ylim}{numeric vectors of length 2, giving the x and y coordinates ranges for the plot.}

\item{xlab}{the title of the x axis.}
}
\description{
Pointwise posterior mean (continuous blue lines), and credible bands (shaded blue areas) for f (y | x, z) 
calculated in \code{x.val} under the the model fitted in \code{fit}.
}
\examples{
{
data(CPP)
attach(CPP)

n <- NROW(CPP)
J <- H <- 10

premature <- as.numeric(gestage<=37)

mcmc <- list(nrep=5000, nb=2000, thin=5, ndisplay=4)

## too few iterations to be meaningful. see below for safer and more comprehensive results

mcmc <- list(nrep=10, nb=2, thin=1, ndisplay=4) 

prior <- list(mu.theta=mean(gestage), k.theta=10, eta=rep(1, J)/J, 
              alpha=rep(1,H)/H, a=2, b=2, J=J, H=H)
              
fit.dummy <- comire.gibbs(gestage, dde, family="continuous", 
                     mcmc=mcmc, prior=prior, seed=1, max.x=180)
                     
fit.pdf.mcmc(y = gestage, x = dde, fit = fit.dummy, mcmc = mcmc, J = 10, H = 10, 
                         alpha = 0.05, max.x = max(dde), x.val = 125, 
                         xlim = c(25,48), ylim = c(0,0.25),
                         xlab = "Gest. age. for DDE = 125")
                         
\donttest{
## safer procedure with more iterations (it may take some time)

mcmc <- list(nrep=5000, nb=2000, thin=5, ndisplay=4)

## Fit the model for continuous y 

prior <- list(mu.theta=mean(gestage), k.theta=10, eta=rep(1, J)/J, 
              alpha=rep(1,H)/H, a=2, b=2, J=J, H=H)
              
fit1 <- comire.gibbs(gestage, dde, family="continuous", 
                     mcmc=mcmc, prior=prior, seed=5, max.x=180)
          
fit.pdf.mcmc(y = gestage, x = dde, fit = fit1, mcmc = mcmc, J = 10, H = 10, 
                         alpha = 0.05, max.x = max(dde), x.val = 125, 
                         xlim = c(25,48), ylim = c(0,0.25),
                         xlab = "Gest. age. for DDE = 125")
                         
}
}
}
\author{
Antonio Canale, Arianna Falcioni
}
