% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UnionCohorts.R
\name{unionCohorts}
\alias{unionCohorts}
\title{Union cohort(s)}
\usage{
unionCohorts(
  connectionDetails = NULL,
  connection = NULL,
  sourceCohortDatabaseSchema = NULL,
  sourceCohortTable,
  targetCohortDatabaseSchema = NULL,
  targetCohortTable,
  oldToNewCohortId,
  isTempTable = FALSE,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  purgeConflicts = FALSE
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{sourceCohortDatabaseSchema}{Schema name where your source cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{sourceCohortTable}{The name of the source cohort table.}

\item{targetCohortDatabaseSchema}{Schema name where your target cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{targetCohortTable}{The name of the target cohort table.}

\item{oldToNewCohortId}{A data.frame object with two columns. oldCohortId and newCohortId. Both should be integers.
The oldCohortId are the cohorts that are the input cohorts that need to be transformed.
The newCohortId are the cohortIds of the corresponding output after transformation.
If the oldCohortId = newCohortId then the data corresponding to oldCohortId
will be replaced by the data from the newCohortId.}

\item{isTempTable}{Is the output a temp table. If yes, a new temp table is created. This will required
an active connection. Any old temp table is dropped and replaced.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}

\item{purgeConflicts}{If there are conflicts in the target cohort table i.e. the target cohort table
already has records with newCohortId, do you want to purge and replace them
with transformed. By default - it will not be replaced, and an error message is thrown.}
}
\value{
Nothing is returned
}
\description{
Given a specified array of cohortIds in a cohort table, perform
cohort union operator to create new cohorts.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
