% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCohortTiming.R
\name{plotCohortTiming}
\alias{plotCohortTiming}
\title{Plot summariseCohortTiming results.}
\usage{
plotCohortTiming(
  result,
  plotType = "boxplot",
  timeScale = "days",
  facet = NULL,
  colour = NULL,
  colourName = NULL,
  uniqueCombinations = TRUE,
  .options = list()
)
}
\arguments{
\item{result}{A summariseCohortTiming result.}

\item{plotType}{Type of desired formatted table, possibilities are "boxplot" and
"density".}

\item{timeScale}{Time scale to plot results. Can be days or years.}

\item{facet}{variables to facet by}

\item{colour}{Variables to use for colours}

\item{colourName}{Colour legend name}

\item{uniqueCombinations}{If TRUE, only unique combinations of reference and
comparator plots will be plotted.}

\item{.options}{Additional plotting options}
}
\value{
A ggplot.
}
\description{
`r lifecycle::badge("experimental")`
}
\examples{
\donttest{
library(CohortCharacteristics)
cdm <- CohortCharacteristics::mockCohortCharacteristics()
timing <- summariseCohortTiming(cdm$cohort2)
plotCohortTiming(timing)
CDMConnector::cdmDisconnect(cdm = cdm)
}

}
