% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCohortAttrition.R
\name{summariseCohortAttrition}
\alias{summariseCohortAttrition}
\title{Summarise attrition associated with cohorts in a cohort table}
\usage{
summariseCohortAttrition(cohort, cohortId = NULL)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{cohortId}{A cohort definition id to restrict by. If NULL, all cohorts
will be included.}
}
\value{
A summary of the attrition for the cohorts in the cohort table.
}
\description{
Summarise attrition associated with cohorts in a cohort table
}
\examples{
\donttest{
library(CohortCharacteristics)
library(dplyr, warn.conflicts = FALSE)

cdm <- mockCohortCharacteristics()

summariseCohortAttrition(cohort = cdm$cohort1) |>
  glimpse()

mockDisconnect(cdm)
}
}
