% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSequenceRatios.R
\name{plotSequenceRatios}
\alias{plotSequenceRatios}
\title{A plot for the sequence ratios.}
\usage{
plotSequenceRatios(
  result,
  onlyASR = FALSE,
  plotTitle = NULL,
  labs = c("SR", "Drug Pairs"),
  colours = c("red", "blue"),
  facet = NULL
)
}
\arguments{
\item{result}{Table output from summariseSequenceRatios.}

\item{onlyASR}{If set to be TRUE then only adjusted SR will be plotted.
Otherwise if it is set to be FALSE then both adjusted and crude SR will be plotted.}

\item{plotTitle}{Title of the plot, if NULL no title will be included in the plot.}

\item{labs}{Axis labels for the plot.}

\item{colours}{Colours for sequence ratio.}

\item{facet}{The variable to facet by.}
}
\value{
A plot for the sequence ratios of index and marker cohorts.
}
\description{
It provides a ggplot of the sequence ratios of index and marker cohorts.
}
\examples{
\donttest{
library(CohortSymmetry)
cdm <- mockCohortSymmetry()
cdm <- generateSequenceCohortSet(cdm = cdm,
                                 indexTable = "cohort_1",
                                 markerTable = "cohort_2",
                                 name = "joined_cohort")
sequence_ratio <- summariseSequenceRatios(cohort = cdm$joined_cohort,
                                          minCellCount = 0)
plotSequenceRatios(result = sequence_ratio)
CDMConnector::cdmDisconnect(cdm = cdm)
}
}
