% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\name{look_up}
\alias{look_up}
\title{Filter list of available datasets based on keywords given by the user}
\usage{
look_up(keywords, module = "all", logic = "or", language = "EN")
}
\arguments{
\item{keywords}{character or vector of characters to be look up in the
description.}

\item{module}{character with module to be consulted (\code{"demographic"},
\code{"geospatial"}, \code{"climate"}). Default is \code{"all"}.}

\item{logic}{A character string specifying the matching logic.
Can be either \code{"or"} or \code{"and"}. Default is \code{"or"}:
\itemize{
\item \code{logic = "or"}: Matches rows containing at least one of the
specified keywords in their descriptions.
\item \code{logic = "and"}: Matches rows containing all of the specified
keywords in their descriptions.
}}

\item{language}{character with the language of the keywords (\code{"EN"} or
\code{"ES"}. Default is \code{"EN"}.}
}
\value{
\code{data.frame} object with the available datasets containing
information related to the consulted keywords.
}
\description{
List available datasets containing user-specified keywords in their
descriptions.
}
\examples{
found <- look_up(c("sex", "age"), "demographic", "and", "EN")
head(found)

}
