% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_nonExistentFiles.R
\name{nonExistentFiles}
\alias{nonExistentFiles}
\title{Non-existent files from a vector of filenames}
\usage{
nonExistentFiles(filenames)
}
\arguments{
\item{filenames}{character A vector of filenames}
}
\value{
A character vector of file paths that do not exist.
}
\description{
This function receives a vector of filenames as parameter, 
and returns a vector of non-existent files among them.
}
\examples{
\dontrun{
nonExistentFiles(R.home())
nonExistentFiles(sapply(1:5, function(i) tempfile()))
nonExistentFiles(sapply(1:5, function(i) tempdir()))
nonExistentFiles(c("/tmp/f3412lds43289ajkfdlsa", R.home())) == "/tmp/f3412lds43289ajkfdlsa"
}

}
\author{
Kaiyin Zhong, Fan Liu
}

