% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{distribution}
\alias{distribution}
\title{Plot the distribution of Colless-Like, Sackin and cophenetic normalized balance indices under the alpha-gamma model and computes the percentile of a tree from previous distributions.}
\usage{
distribution(tree, alpha = NA, gamma = NA, set.indices = NULL,
  new.simulation = FALSE, repetitions = 1000,
  legend.location = "topright", cex = 0.75, percentile.plot = FALSE,
  db.path = getwd())
}
\arguments{
\item{tree}{a single phylogenetic tree. It can be entered as a string in Newick format, as a "phylo" object (\code{ape} package) or as an "igraph" object (\code{igraph} package).}

\item{alpha}{parametrer of the alpha-gamma model, between 0 and 1.}

\item{gamma}{parametrer of the alpha-gamma model, between 0 and alpha.}

\item{set.indices}{If \code{NULL} (default) the values of the balance indices are taken from stored data or from a new simulated data (See "Details"). If not, it must be a 3-column data.frame with the three balance indices (Colles-like, Sackin, Cophenetic). See \code{\link{indices.simulation}}.}

\item{new.simulation}{if \code{FALSE}(default) the values of the balance indices are taken from a data.frame entered by the user or from our database. If \code{TRUE}, the values of the balance indices are computed from a new simulation. See \code{\link{indices.simulation}}.}

\item{repetitions}{if the value of the new.simulation parameter is \code{TRUE}, the number of trees to be generated.}

\item{legend.location}{location of the legend. See "Details".}

\item{cex}{expansion factor of the legend. See "Details".}

\item{percentile.plot}{if \code{FALSE} (default),  density plots of the normalized balance indices are shown. if \code{TRUE}, percentiles plots of the normalized balance indices are shown.}

\item{db.path}{the current working directory. If our database is used, the db.path parameter should be the directory where the database is located.}
}
\value{
A numeric vector with the three percentiles.
}
\description{
Given alpha, gamma and a phylogenetic tree, plot the distribution of the Colless-Like, Sackin and cophenetic normalized balance indices under the alpha-gamma model and computes the percentile of that tree of the previous normalized balance indices under the alpha-gamma model.
}
\details{
Two plots are available: one represents the percentile plots of the normalized balance indices (\code{percentile.plot=TRUE}), and the other one represents the density plots of the normalized balance indices (\code{percentile.plot=FALSE}).

The trees stored in our database have between 3 and 50 leaves and the values of the parameters \code{alpha} and \code{gamma} are in \{0,0.1,...,1\} such that {\code{gamma} \eqn{\le} \code{alpha}}. If the introduced parameters are not in the list, a new computation is done with them and a new dataset of trees is generated, and their indices are also computed. The number of trees generated can be modified by the parameter \code{repetitions} (see \code{\link{indices.simulation}} for more information). This computation may take some time, therefore you can computate them separately with \code{\link{indices.simulation}}, save their values and then call this function  by setting the parameter \code{set.indices=NULL}.

Our database is available to download at \url{https://github.com/LuciaRotger/CollessLike/tree/master/CollessLikeDataBase}.

The legend is placed with the \code{graphics} function \code{legend()}, so its location can be specified by setting \code{legend.position} to a single keyword from the list \code{"bottomright"}, \code{"bottom"}, \code{"bottomleft"}, \code{"left"}, \code{"topleft"}, \code{"top"}, \code{"topright"}, \code{"right"} and \code{"center"}. 
The expansion factor for the legend is controlled by the parameter \code{cex}, by default \code{cex=1}. See \code{\link[graphics]{legend}}.
}
\examples{
#The parameter folder contains the location of the database
#If not specified folder=getwd()

## Different ways to introduce the tree
#From a newick string
\donttest{distribution("(1,2,3,4,5);",0.5,0.3,db.path=folder)}
\donttest{distribution("(1,(2,(3,(4,5))));",0.5,0.3,db.path=folder)}

#From a phylo object
\donttest{require(ape)}
\donttest{random.tree = rtree(5,rooted=TRUE)}
\donttest{distribution(random.tree,0.5,0.3,db.path=folder)}

#An example of a tree generated by the alpha-gamma model (igraph object)
\donttest{a.g.tree = a.g.model(5,0.5,0.3)}
\donttest{distribution(a.g.tree,0.5,0.3,db.path=folder)}

## Different indices data
# From our data base
\donttest{distribution(a.g.tree,0.5,0.3,db.path=folder)}

# From a data.frame generated by 'indices.simulation'
# ('Repetitions' set as 10 for a fast example)
\donttest{indices.data = indices.simulation(5,0.5,0.3,10)}
\donttest{distribution(a.g.tree,0.5,0.3,set.indices=indices.data) }

# Allow the function to do a new generation of data and compute their indices
\donttest{distribution(a.g.tree,0.5,0.3,new.simulation=TRUE,repetitions=10)}
# WARNING! it might take a long time, it depends on the parameters 
# 'n' (number of leaves) and 'repetition' (number of repetitions)

}
\references{
B. Chen, D. Ford, M. Winkel, A new family of Markov branching trees: the alpha-gamma model. \emph{Electr. J. Probab}. \bold{14} (2009), 400-430. 

A. Mir, F. Rossello, L.Rotger, A Colless-like balance index for multifurcating phylogenetic trees.\emph{}

A. Mir, F. Rossello, L.Rotger, A new balance index for phylogenetic trees. \emph{Mathematical Biosciences} \bold{241} (2013), 125-136.

M. J. Sackin, "Good" and  "bad" phenograms. \emph{Sys. Zool}, \bold{21} (1972), 225-226.
}
\seealso{
\code{\link[graphics]{legend}}, \code{\link{indices.simulation}}, \code{\link{balance.indices}}
}
\author{
Lucia Rotger
}
