% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_shiny.R
\name{age_shiny}
\alias{age_shiny}
\title{Lifespan Age Trends}
\usage{
age_shiny(age_list, features, quantile_type, use_plotly = TRUE)
}
\arguments{
\item{age_list}{A list containing all ROIs' true volumes, age trend estimates, and the fitted GAMLSS model.}

\item{features}{A vector of roi names.}

\item{quantile_type}{A vector of quantile types (e.g., \code{c("quantile_25", "median", "quantile_75")})}

\item{use_plotly}{A boolean variable that indicates whether to display the age plot using the \code{plotly} package.}
}
\value{
This function does not return a value. It launches a Shiny app.
}
\description{
Provide estimated lifespan age trends of neuroimaging-derived brain structures through shiny app.
}
\details{
When this function is called, it starts a Shiny application in the
user's default web browser. Execution is blocked until the app is closed.
}
\examples{
sub_df <- age_df[,c("Volume_1", "age", "sex", "ICV_baseline")] |> na.omit()
colnames(sub_df) <- c("Volume_1", "age", "sex", "icv")
age_list <- list("Volume_1" = age_list_gen(sub_df = sub_df))
quantile_type <- c("quantile_25", "median", "quantile_75")
if(interactive()){
  age_shiny(age_list = age_list, features = "Volume_1", quantile_type = quantile_type)
}
}
