% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Help_Func.R
\name{.biweight_midvar}
\alias{.biweight_midvar}
\title{Biweight Midvariance Calculation}
\usage{
.biweight_midvar(data, center = NULL, norm.unbiased = TRUE)
}
\arguments{
\item{data}{A numeric vector containing the data points for which the biweight midvariance is to be calculated.}

\item{center}{An optional parameter specifying the central location of the data. If not provided, the function defaults to using the median of the data.}

\item{norm.unbiased}{A logical parameter (default: \code{TRUE}) indicating whether to use a normalization constant for unbiased estimation. When \code{TRUE}, the constant is adjusted to 9 divided by the quantile function of 0.75 from the standard normal distribution.}
}
\value{
A numeric value representing the robust biweight midvariance estimate.
}
\description{
Compute a robust estimate of midvariance using the biweight method, which reduces the influence of outliers by applying a weighting function to the data based on their deviation from a central value.
}
\examples{
data <- c(1, 2, 3, 4, 100)
biweight_var <- .biweight_midvar(data)
print(biweight_var)
}
