% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venn.R
\name{scale_color_venn_mix}
\alias{scale_color_venn_mix}
\title{Color scale for Venn diagram}
\usage{
scale_color_venn_mix(
  data,
  sets = NULL,
  colors = c("red", "blue", "green"),
  na.value = "grey40",
  highlight = NULL,
  active_color = "orange",
  inactive_color = "NA",
  scale = scale_color_manual,
  ...
)
}
\arguments{
\item{data}{a dataframe including binary columns representing membership in sets}

\item{sets}{vector with names of columns representing membership in sets}

\item{colors}{named list of colors for sets (one set=one color)}

\item{na.value}{value for elements not belonging to any of the sets}

\item{highlight}{which regions of the diagram to highlight}

\item{active_color}{color for highlight}

\item{inactive_color}{color for lack of highlight}

\item{scale}{the base scale (default=\code{scale_color_manual()})}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:scale_manual]{ggplot2::scale_color_manual}}
  \describe{
    \item{\code{values}}{a set of aesthetic values to map data values to. The values
will be matched in order (usually alphabetical) with the limits of the
scale, or with \code{breaks} if provided. If this is a named vector, then the
values will be matched based on the names instead. Data values that don't
match will be given \code{na.value}.}
    \item{\code{aesthetics}}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the \code{colour} and \code{fill} aesthetics at the
same time, via \code{aesthetics = c("colour", "fill")}.}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}
  }}
}
\description{
Color scale for Venn diagram
}
