% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IUCNeval.functionv11.R
\name{locations.comp}
\alias{locations.comp}
\title{Number of locations}
\usage{
locations.comp(
  XY,
  method = "fixed_grid",
  nbe_rep = 0,
  protec.areas = NULL,
  Cell_size_locations = 10,
  method_protected_area = "no_more_than_one",
  ID_shape_PA = "WDPA_PID",
  Rel_cell_size = 0.05,
  parallel = FALSE,
  NbeCores = 2,
  show_progress = TRUE
)
}
\arguments{
\item{XY}{data.frame, see details}

\item{method}{string, indicating the method used for estimating the number of locations. Either "fixed_grid" or "sliding scale". See details. By default, it is "fixed_grid"}

\item{nbe_rep}{numeric , indicate the number of raster with random starting position for estimating the number of locations By default, it is 0 but some minimal translation of the raster are still done}

\item{protec.areas}{\code{SpatialPolygonsDataFrame}, shapefile with protected areas. If provided, this will be taken into account for calculating number of location (see Details and \code{method_protected_area}). By default, no shapefile is provided}

\item{Cell_size_locations}{numeric, value indicating the grid size in kilometers used for estimating the number of location. By default, equal to 10}

\item{method_protected_area}{string, by default is "no_more_than_one"", which means occurrences within protected areas (if provided) will not be taken into account for estimating the number of locations following the grid system, see Details. By default, it is "no_more_than_one"}

\item{ID_shape_PA}{string, indicating the field name of \code{protec.areas} with ID of the \code{SpatialPolygonsDataFrame} of protected areas}

\item{Rel_cell_size}{numeric, if \code{method_locations="sliding scale"}, \code{Cell_size_locations} is ignored and the resolution is given by the maximum distance separating two occurrences multiplied by \code{Rel_cell_size}. By default, it is 0.05}

\item{parallel}{logical, whether running in parallel. By default, it is FALSE}

\item{NbeCores}{string integer, register the number of cores for parallel execution. By default, it is 2}

\item{show_progress}{logical, whether a bar showing progress in computation should be shown. By default, it is TRUE}
}
\value{
A list with one list for each species containing [[1]]SpatialPolygonDataframe and [[2]]vector of the number of location.
}
\description{
Estimate the number of locations for multiple taxa
}
\details{
\strong{Input} as a \code{dataframe} should have the following structure:

\strong{It is mandatory to respect field positions, but field names do not matter}

\tabular{ccc}{
  [,1] \tab ddlat \tab numeric, latitude (in decimal degrees)\cr
  [,2] \tab ddlon \tab numeric, longitude (in decimal degrees)\cr
  [,3] \tab tax \tab character or factor, taxa names\cr
}
}
\examples{
data(dataset.ex)
\dontrun{
locations <- locations.comp(dataset.ex)
}

# This would estimate the number of locations for all taxa by overlaying 
# randomly a grid 100 times. For each taxa, the minimum value is kept
\dontrun{
locations <- locations.comp(dataset.ex, nbe_rep = 100)
}

}
\references{
Gaston & Fuller 2009 The sizes of species'geographic ranges, Journal of Applied Ecology, 49 1-9
}
\author{
Gilles Dauby, \email{gildauby@gmail.com}
}
