% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_ellipse.R
\name{confidence_ellipse}
\alias{confidence_ellipse}
\title{Confidence Ellipse Coordinates}
\usage{
confidence_ellipse(
  .data,
  x,
  y,
  .group_by = NULL,
  conf_level = 0.95,
  robust = FALSE
)
}
\arguments{
\item{.data}{data frame or tibble.}

\item{x}{column name for the x-axis variable.}

\item{y}{column name for the y-axis variable.}

\item{.group_by}{column name for the grouping variable (\code{NULL} by default). Note that this grouping variable must be a factor.}

\item{conf_level}{confidence level for the ellipse (0.95 by default).}

\item{robust}{optional (\code{FALSE} by default). When set to \code{TRUE}, it indicates that robust estimation method is employed to calculate the coordinates of the ellipse. The location is the 1-step M-estimator with the biweight psi function. The scale is the Minimum Covariance Determinant (MCD) estimator. Raymaekers and Rousseeuw (2019).}
}
\value{
Data frame of the coordinates points.
}
\description{
Compute the coordinate points of confidence ellipses at a specified confidence level.
}
\examples{
# Data
data("glass", package = "ConfidenceEllipse")
# Confidence ellipse
ellipse <- confidence_ellipse(.data = glass, x = SiO2, y = Na2O)
ellipse_grp <- confidence_ellipse(
.data = glass,
x = SiO2,
y = Na2O,
.group_by = glassType
)

}
\author{
Christian L. Goueguel
}
