% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCCGARCHselection.R
\name{DCCGARCHselection}
\alias{DCCGARCHselection}
\title{DCC-GARCH selection specification}
\usage{
DCCGARCHselection(
  x,
  distributions = c("norm", "snorm", "std", "sstd", "ged", "sged"),
  models = c("sGARCH", "eGARCH", "gjrGARCH", "iGARCH", "TGARCH", "AVGARCH", "NGARCH",
    "NAGARCH", "APARCH", "ALLGARCH"),
  prob = 0.05,
  conf.level = 0.9,
  lag = 20,
  ar = 0,
  ma = 0
)
}
\arguments{
\item{x}{zoo data matrix}

\item{distributions}{Vector of distributions}

\item{models}{Vector of GARCH models}

\item{prob}{The quantile (coverage) used for the VaR.}

\item{conf.level}{Confidence level of VaR test statistics}

\item{lag}{Lag length of weighted Portmanteau statistics}

\item{ar}{AR(p)}

\item{ma}{MA(q)}
}
\value{
Get best DCC-GARCH
}
\description{
This function calculates the optimal DCC-GARCH specification
}
\references{
Ghalanos, A. (2014). rugarch: Univariate GARCH models, R package version 1.3-3.

Antonakakis, N., Chatziantoniou, I., & Gabauer, D. (2021). The impact of Euro through time: Exchange rate dynamics under different regimes. International Journal of Finance & Economics, 26(1), 1375-1408.
}
\author{
David Gabauer
}
