% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kemenyscore.R
\name{kemenyscore}
\alias{kemenyscore}
\title{Score matrix according Kemeny (1962)}
\usage{
kemenyscore(X)
}
\arguments{
\item{X}{a ranking (must be a row vector or, better, a matrix with one row and M columns)}
}
\value{
the M by M score matrix
}
\description{
Given a ranking, it computes the score matrix as defined by Emond and Mason (2002)
}
\examples{
Y <- matrix(c(1,3,5,4,2),1,5)
SM<-kemenyscore(Y)
#
Z<-c(1,2,3,2)
SM2<-kemenyscore(Z)

}
\references{
Kemeny, J and Snell, L. (1962). Mathematical models in the social sciences.
}
\seealso{
\code{\link{scorematrix}} The score matrix as defined by Emond and Mason (2002)
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
