% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_twitter_users_json}
\alias{load_twitter_users_json}
\title{load_twitter_users_json}
\usage{
load_twitter_users_json(data_dir, query_error_ok = TRUE)
}
\arguments{
\item{data_dir}{string that leads to the directory containing JSON files}

\item{query_error_ok}{(Boolean) stop if \code{query} causes an error. Passed on
to \link[RcppSimdJson]{fload} (optional). Default: \code{TRUE}}
}
\value{
a data.table with all users loaded
}
\description{
Very efficient and fast way to load user information from JSON files.
Wrapper of the function \link[RcppSimdJson]{fload}
}
\details{
This function is optimized to load user data JSON files that were
collected using the academicTwittr Package (Twitter API V2).
It uses RcppSimdJson to load the JSON files, which is extremely
fast and efficient. It returns the user data as is. The only changes
are that the function renames the \code{id} of tweets to \code{user_id}, and
it also deduplicates the data (by \code{user_id}).
The function expects that the individual JSON files start with \code{user}.
}
