% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copernicus_cite_product.r
\name{copernicus_cite_product}
\alias{copernicus_cite_product}
\title{How to cite a Copernicus marine product}
\usage{
copernicus_cite_product(product)
}
\arguments{
\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{copernicus_products_list}}.}
}
\value{
Returns a vector of character strings. The first element is always the product title, id and doi.
Remaining elements are other associated references. Note that the remaining references are returned as
listed at Copernicus. Note that the citing formatting does not appear to be standardised.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Get details for properly citing a Copernicus product.
}
\examples{
\dontrun{
copernicus_cite_product("SST_MED_PHY_SUBSKIN_L4_NRT_010_036")
}
}
\seealso{
Other product-functions: 
\code{\link{cms_cite_product}()},
\code{\link{cms_product_details}()},
\code{\link{cms_product_metadata}()},
\code{\link{cms_product_services}()},
\code{\link{cms_products_list}()},
\code{\link{copernicus_product_details}()},
\code{\link{copernicus_product_metadata}()},
\code{\link{copernicus_products_list}()}
}
\author{
Pepijn de Vries
}
\concept{product-functions}
