% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coplik.R
\name{mlecop.disc}
\alias{mlecop.disc}
\title{Estimation of the parameter of a bivariate copula (Clayton, Frank, Gumbel) when the first observation is 0 or 1}
\usage{
mlecop.disc(y, v, fcopders, start = 2, LB = 1.01, UB = 7)
}
\arguments{
\item{y}{vector of binary values 0 or 1}

\item{v}{vector of values in (0,1)}

\item{fcopders}{ffrkders, fgumders or fmtcjders}

\item{start}{starting value for the parameter (default =2)}

\item{LB}{lower bound for the parameter (default is 1.01)}

\item{UB}{upper bound for the parameter (default is 7)}
}
\value{
\item{mle}{List of outputs from nlm function}
}
\description{
Computes the MLE estimation for a bivariate copula using gradient. The likelihood is likelihood is C(1-p|v;theta) if y=0 and 1-C(1-p|v;theta) if y=1
}
\examples{
set.seed(2)
v = runif(250)
w = runif(250)
u = 1/sqrt(1+(w^(-2/3)-1)/v^2) #Clayton with parameter 2
y = as.numeric(u>0.6) # if one takes (u<4), one obtains a rotation of the Clayton!
out = mlecop.disc(y,v,fmtcjders)
}
\author{
Pavel Krupskii
}
