% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expcondinv.R
\name{expcondinv}
\alias{expcondinv}
\title{Inverse conditional expectation for a vector of probabilities}
\usage{
expcondinv(u, family, cpar, rot = 0, margin, subs = 1000, eps = 1e-04)
}
\arguments{
\item{u}{conditional expectation}

\item{family}{copula model: "gaussian" , "t" , "clayton"   "joe", "frank" , "gumbel",  "plackett"}

\item{cpar}{copula parameter}

\item{rot}{rotation: 0 (default), 90, 180 (survival), or 270}

\item{margin}{marginal distribution function of the response}

\item{subs}{number of subdivisions for the integrals (default=1000)}

\item{eps}{precision required}
}
\value{
\item{minv}{Inverse conditional expectation}
}
\description{
This function computes the inverse conditional expecatation for a given copula family and a given margin variables for a clustered data model. The clusters ar3e independent but the observations with clusters are dependent, according to a one-factor copula model.
}
\author{
Pavel Krupskii and Bruno N. Remillard
}
