% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deg_normalization.R
\name{URG_getFactor}
\alias{URG_getFactor}
\title{Calculate normalization factors for URG method}
\usage{
URG_getFactor(expr.matrix, p.edge = 0.25, p.gene = 0.4, log.expr = FALSE)
}
\arguments{
\item{expr.matrix}{The expression matrix. Each row represents a gene and each column represents a sample.}

\item{p.edge}{The percentage of gene pairs that are selected into the uniform ratio graph.}

\item{p.gene}{The maximal percentage of genes that are selected as the stable genes.}

\item{log.expr}{Logical variable indicating whether the input expression matrix is in logarithmic scale.}
}
\value{
This function will return a numeric vector with each element [i] represents the normalization
factor of sample (i).
}
\description{
Calculate the normalization factor for each sample by using URG (uniform ratio graph) method.
}
\references{
Xinhan Ye, Ling-Yun Wu. URG: a new normalization method for 
gene expression data based on graph model. Manuscript.
}
\seealso{
\code{\link{URG_normalize}}
}
