% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deg_simulation.R
\name{make_DEG_pattern}
\alias{make_DEG_pattern}
\title{Simulate differentially expressed gene pattern}
\usage{
make_DEG_pattern(
  n.genes,
  n.samples,
  fold.change = 2,
  gene.rate = 0.3,
  sample.rate = 1,
  active.rate = 1,
  up.rate = 0.5
)
}
\arguments{
\item{n.genes}{The total number of genes in the simulated data.}

\item{n.samples}{The total number of samples in the simulated data.}

\item{fold.change}{The fold change level of DEGs.}

\item{gene.rate}{The proportion of DEGs to all genes.}

\item{sample.rate}{The proportion of abnormal samples to all samples.}

\item{active.rate}{The probability that a DEG is truely differentially 
expressed in an abnormal sample.}

\item{up.rate}{The proportion of up-regulated DEGs to all DEGs.}
}
\value{
This function will return a list with the following components:
  \item{FC}{The matrix of simulated fold changes. Each row represents a gene and each column represents a sample.}
  \item{gene}{The vector of gene status: 1 for up-regulated, -1 for down-regulated, and 0 for normal genes.}
  \item{sample}{The vector of sample status: 1 for abnormal, and 0 for normal samples.}
}
\description{
Generate complicated differentially expressed gene (DEG) pattern to simulate 
varied degree of heterogeneity.
}
\details{
The heterogeneity of gene expression pattern is mainly controlled by
two parameters: \code{sample.rate} and \code{active.rate}. If both
parameters are equal to 1, the gene expression pattern will be homogeneous,
otherwise heterogeneous.
}
