% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovEst.nearPD.R
\name{CovEst.nearPD}
\alias{CovEst.nearPD}
\title{Covariance Estimation via Nearest Positive-Definite Matrix Projection}
\usage{
CovEst.nearPD(X)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix where each row is an observation.}
}
\value{
a named list containing: \describe{
\item{S}{a \eqn{(p\times p)} covariance matrix estimate.}
}
}
\description{
Qi and Sun (2006) proposed an algorithm for computing the positive correlation matrix
with Positive Definiteness and transforming it back in order to estimate covariance matrix.
This algorithm does not depend on any parameters.
}
\examples{
## generate data from multivariate normal with Identity covariance.
data <- mvtnorm::rmvnorm(3, sigma=diag(10))

## compare against sample covariance
out1 <- cov(data)
out2 <- CovEst.nearPD(data) # apply nearPD

## visualize 2 estimated matrices
par(mfrow=c(1,2), pty="s")
image(pracma::flipud(out1), col=gray((0:100)/100), main="sample covariance")
image(pracma::flipud(out2$S), col=gray((0:100)/100), main="SPD Projection")

}
\references{
\insertRef{qi_quadratically_2006}{CovTools}
}
