% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovTest2.R
\name{CovTest2}
\alias{CovTest2}
\title{Two-Sample Tests for Covariance Matrices}
\usage{
CovTest2(X, Y, alpha = 0.05, method = c("Cai13"))
}
\arguments{
\item{X}{an \eqn{(m\times p)}  matrix where each row is an observation from the first dataset.}

\item{Y}{an \eqn{(n\times p)} matrix where each row is an observation from the second dataset.}

\item{alpha}{level of significance.}

\item{method}{a name of test.}
}
\value{
a named list containing \describe{
\item{statistic}{a test statistic value.}
\item{threshold}{rejection criterion to be compared against test statistic.}
\item{reject}{a logical; \code{TRUE} to reject null hypothesis, \code{FALSE} otherwise.}
}
}
\description{
Given two sets of data, \code{CovTest2} performs 2-sample test for Covariance where
the null hypothesis is
\deqn{H_0 : \Sigma_1 = \Sigma_2}
where \eqn{\Sigma_1} and \eqn{\Sigma_2} represent true (unknown) covariance
for each dataset.
}
\examples{
## generate 2 datasets from multivariate normal with identical covariance.
data1 = mvtnorm::rmvnorm(100, sigma=diag(5))
data2 = mvtnorm::rmvnorm(200, sigma=diag(5))

## run test
CovTest2(data1, data2)

}
\references{
\insertRef{cai_optimal_2013}{CovTools}
}
