% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovEst.nearPD.R
\name{CovEst.nearPD}
\alias{CovEst.nearPD}
\title{Covariance Estimation via Nearest Positive-Definite Matrix Projection}
\usage{
CovEst.nearPD(X)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix where each row is an observation.}
}
\value{
a named list containing: \describe{
\item{S}{a \eqn{(p\times p)} covariance matrix estimate.}
}
}
\description{
Qi and Sun (2006) proposed an algorithm for computing the positive correlation matrix
with Positive Definiteness and transforming it back in order to estimate covariance matrix.
This algorithm does not depend on any parameters.
}
\examples{
## generate data from multivariate normal with Identity covariance.
pdim <- 5
data <- matrix(rnorm(10*pdim), ncol=pdim)

## compare against sample covariance
out1 <- cov(data)
out2 <- CovEst.nearPD(data) # apply nearPD

## visualize 2 estimated matrices
gcol <- gray((0:100)/100)
opar <- par(mfrow=c(1,2), pty="s")
image(out1[,pdim:1],   col=gcol, main="sample covariance")
image(out2$S[,pdim:1], col=gcol, main="SPD Projection")
par(opar)

}
\references{
\insertRef{qi_quadratically_2006}{CovTools}
}
