% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{plot_PLS_Coxmos}
\alias{plot_PLS_Coxmos}
\title{plot_PLS_Coxmos}
\usage{
plot_PLS_Coxmos(
  model,
  comp = c(1, 2),
  mode = "scores",
  factor = NULL,
  legend_title = NULL,
  top = NULL,
  only_top = FALSE,
  radius = NULL,
  names = TRUE,
  colorReverse = FALSE,
  text.size = 2,
  overlaps = 10
)
}
\arguments{
\item{model}{Coxmos model.}

\item{comp}{Numeric vector. Vector of length two. Select which components to plot (default: c(1,2)).}

\item{mode}{Character. Choose one of the following plots: "scores", "loadings" o "biplot"
(default: "scores").}

\item{factor}{Factor. Factor variable to color the observations. If factor = NULL, event will be
used (default: NULL).}

\item{legend_title}{Character. Legend title (default: NULL).}

\item{top}{Numeric. Show "top" first variables. If top = NULL, all variables are shown (default: NULL).}

\item{only_top}{Logical. If "only_top" = TRUE, then only top/radius loading variables will be
shown in loading or biplot graph (default: FALSE).}

\item{radius}{Numeric. Radius size (loading/scale value) to plot variable names that are greater
than the radius value (default: NULL).}

\item{names}{Logical. Show loading names for top variables or for those that are outside the radius
size (default: TRUE).}

\item{colorReverse}{Logical. Reverse palette colors (default: FALSE).}

\item{text.size}{Numeric. Text size (default: 2).}

\item{overlaps}{Numeric. Number of overlaps to show when plotting loading names (default: 10).}
}
\value{
A list of two elements.
\code{plot}: Score, Loading or Biplot graph in 'ggplot2' format.
\code{outliers}: Data.frame of outliers detected in the plot.
}
\description{
Visualizes the Coxmos models based on partial least squares (PLS) or Multi-block PLS approaches.
This function offers various plotting modes, including scores, loadings, and biplot visualizations,
to provide insights into the model's structure and relationships.
}
\details{
The plot_Coxmos.PLS.model function is designed to generate comprehensive visualizations of the
Coxmos models. It leverages the inherent structure of the model to produce plots that can aid in
the interpretation of the model's components and their relationships.

Depending on the chosen mode, the function can display:
\itemize{
\item Scores: This mode visualizes the scores of the model, which represent the projections of the
original data onto the PLS components. The scores can be colored by a factor variable, and
ellipses can be added to represent the distribution of the scores.
\item Loadings: This mode displays the loadings of the model, which indicate the contribution of each
variable to the PLS components. The loadings can be filtered by a specified threshold
(top or radius), and arrows can be added to represent the direction and magnitude of the loadings.
\item Biplot: A biplot combines both scores and loadings in a single plot, providing a comprehensive
view of the relationships between the observations and variables in the model.
}

The function also offers various customization options, such as adjusting the text size, reversing
the color palette, and specifying the number of overlaps for loading names. It ensures that the
visualizations are informative and tailored to the user's preferences and the specific
characteristics of the data.

It's important to note that the function performs checks to ensure the input model is of the
correct class and provides informative messages for any inconsistencies detected.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
X <- X_proteomic[,1:50]
Y <- Y_proteomic
splsicox.model <- splsicox(X, Y, n.comp = 2, penalty = 0.5, x.center = TRUE, x.scale = TRUE)
plot_PLS_Coxmos(splsicox.model, comp = c(1,2), mode = "scores")
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
