% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_rotation.R
\name{best_rotation}
\alias{best_rotation}
\title{Find the best rotated image for crop row detection}
\usage{
best_rotation(picture_list, ratio, intensity)
}
\arguments{
\item{picture_list}{One or more images created from rotating the same image.}

\item{ratio}{Any number, typically (0-1) that will be the ratio needed to determine a true crop row.}

\item{intensity}{The amount of smoothing of the image.}
}
\value{
The index of the image with the most \emph{good ratios} (ratios that exceed the given threshold).
}
\description{
Analyzes the list of rotated images of crop rows and finds the best angle of rotation for row detection.
}
\details{
This takes in a list of images and looks at the average of each column in the form of an arry.
Ideally the image is black and white, with crops being white, so the range of numbers in the array {0,1}.

The function then smooths out the array using \code{\link{smoothing}} so the local minima and maximas using (\code{\link{localMaxima}} and \code{\link{localMaxima}}) are more pronounced,
then creates two vectors of the local min/max of each image.
Then the ratio between neighbor local minima and maxima are calculated and compared to
a threshold given by the user. If the found ratio is larger than the threshold the ratio
is counted.
}
\examples{
\donttest{best_image <- best_rotation(picture_list, 0.5, 0.25)}

}
