% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetCDLImage.R
\name{GetCDLImage}
\alias{GetCDLImage}
\title{Request images of the CDL data}
\usage{
GetCDLImage(
  aoi = NULL,
  year = NULL,
  type = NULL,
  format = "png",
  crs = NULL,
  destfile = NULL,
  verbose = TRUE,
  tol_time = 20
)
}
\arguments{
\item{aoi}{Area of interest. Can be a 5-digit FIPS code of a county, 2-digit FIPS code of a state, four corner points or an sf object that defines a rectangle (or a box) area,
multiple coordinates that defines a polygon, or a URL of an compressed ESRI shapefile.}

\item{year}{Year of data. Should be a 4-digit numeric value.}

\item{type}{Type of the selected AOI. 'f' for county, 'b' for box area, 'ps' for polygon, 's' for ESRI shapefile.}

\item{format}{Format of the image file. Can be png or kml.}

\item{crs}{Coordinate system. \code{NULL} if use the default coordinate system (i.e., Albers projection); Use '+init=epsg:4326' for longitude/latitude.}

\item{destfile}{A character string that specifies the directory to save the downloaded image file (e.g., 'C:/image.png'). Note that
the name of the image file should be specified as well. If not providing \code{destfile}, the function will create a temporary folder to save the image file.}

\item{verbose}{\code{TRUE}/\code{FALSE}. Display the directory saving the file or not.}

\item{tol_time}{Number of seconds to wait for a response until giving up. Default is 20 seconds.}
}
\value{
The function downloads an image file in png or kml format to users' computer. This function is different to \code{GetCDLData} that returns a raster TIF file.
}
\description{
A function that requests images of the CDL data for an area of interests in a given year from the CropScape.
This function implements the GetCDLImage service provided by the CropScape \url{https://nassgeodata.gmu.edu/CropScape}.
}
\details{
The usage of this function is similar to the \code{GetCDLData} function. Please see the help page of the \code{GetCDLData} function
for details. Note that the \code{aoi} cannot be a single point here.
}
