/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.io.FileTransfer;
import org.af.commons.logging.LoggingSystem;
import org.af.commons.logging.widgets.DetailsDialog;
import org.af.commons.tools.OSTools;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.Configuration;
import org.mutoss.gui.CrossoverGUI;
import org.mutoss.gui.RControl;
import org.mutoss.gui.dialogs.AboutDialog;
import org.mutoss.gui.dialogs.RObjectLoadingDialog;
import org.mutoss.gui.dialogs.TextFileViewer;
import org.mutoss.gui.options.OptionsDialog;

public class MenuBarCrossover
extends JMenuBar
implements ActionListener {
    private static final Log logger = LogFactory.getLog(MenuBarCrossover.class);
    JMenu fmenu = new JMenu("File");
    JMenu extraMenu = new JMenu("Extras");
    CrossoverGUI control;
    public String LATEX_BEGIN_DOCUMENT = "\\documentclass[11pt]{article}\n\\usepackage{tikz}\n\\usetikzlibrary{decorations,arrows,shapes}\n\\begin{document}\n";
    public String LATEX_END_DOCUMENT = "\\end{document}";

    public MenuBarCrossover(CrossoverGUI control) {
        this.control = control;
        this.fmenu.add(this.makeMenuItem("Exit", "exit", 88));
        this.fmenu.setMnemonic(70);
        this.add(this.fmenu);
        JMenu menu = new JMenu("Analysis");
        menu.setMnemonic(65);
        menu.add(this.makeMenuItem("Extended analysis", "analysis"));
        this.add(menu);
        this.createExtraMenu();
        this.add(this.extraMenu);
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menu.add(this.makeMenuItem("About", "showAbout", 66));
        menu.add(this.makeMenuItem("Package vignette", "showAppHelp", 73));
        menu.addSeparator();
        menu.add(this.makeMenuItem("Version Info / NEWS", "showNEWS", 78));
        this.add(menu);
    }

    public void createExtraMenu() {
        this.extraMenu.removeAll();
        this.extraMenu.add(this.makeMenuItem("Options", "showOptions", 79));
        this.extraMenu.add(this.makeMenuItem("Set all options back to default", "clearOptions", 67));
        this.extraMenu.addSeparator();
        this.extraMenu.add(this.makeMenuItem("Log", "showLog", 76));
        this.extraMenu.add(this.makeMenuItem("Report error", "reportError", 82));
        if (System.getProperty("eclipse") != null) {
            this.extraMenu.add(this.makeMenuItem("Debug console", "debugConsole", 68));
            this.extraMenu.add(this.makeMenuItem("Save archives", "saveArchive", 65));
        }
        this.extraMenu.setMnemonic(69);
    }

    private void createLastUsed() {
        int i;
        List<String> graphs = Configuration.getInstance().getGeneralConfig().getLatestGraphs();
        for (i = this.fmenu.getItemCount() - 1; i > 16; --i) {
            this.fmenu.remove(i);
        }
        if (graphs.size() > 0) {
            i = 0;
            for (String graph : graphs) {
                ++i;
                String s = graph;
                logger.info((Object)("Process last used graph: '" + s + "'."));
                File f = new File(s);
                if (f.exists()) {
                    String path = f.getParent();
                    if (path.length() > 20) {
                        path = path.substring(0, 17) + "...";
                    }
                    s = f.getName() + " [" + path + "]";
                    this.fmenu.add(this.makeMenuItem(i + " " + s, "LOAD_GRAPH" + graph, (i + "").charAt(0)));
                    continue;
                }
                if (!s.startsWith("R Object: ")) continue;
                s = s.substring(10);
                if (!RControl.getR().eval("exists(\"" + s + "\")").asRLogical().getData()[0]) continue;
                this.fmenu.add(this.makeMenuItem(i + " " + s, "LOAD_GRAPH" + graph, (i + "").charAt(0)));
            }
            this.fmenu.addSeparator();
        }
        this.fmenu.add(this.makeMenuItem("Exit", "exit", 88));
    }

    private JMenuItem makeMenuItem(String text, String action, int key) {
        JMenuItem item = this.makeMenuItem(text, action);
        item.setMnemonic(key);
        return item;
    }

    private JMenuItem makeMenuItem(String text, String action, char key) {
        JMenuItem item = this.makeMenuItem(text, action);
        item.setMnemonic(key);
        return item;
    }

    public void showAbout() {
        new AboutDialog(this.control);
    }

    public void showLog() {
        new DetailsDialog(LoggingSystem.getInstance().makeDetailsPanel());
    }

    public void reportError() {
        ErrorHandler.getInstance().makeErrDialog("Report Error");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("save graph to R")) {
            JOptionPane.showMessageDialog(this.control, "Will not save empty graph.", "Saving to R failed.", 0);
            return;
        }
        if (e.getActionCommand().equals("load design from R")) {
            new RObjectLoadingDialog(this.control, "Select design");
            this.createLastUsed();
        } else if (e.getActionCommand().equals("saveArchive")) {
            this.control.dac.save();
        } else if (e.getActionCommand().equals("showLog")) {
            this.showLog();
        } else if (e.getActionCommand().equals("reportError")) {
            this.reportError();
        } else if (e.getActionCommand().equals("exit")) {
            this.control.windowClosing(null);
        } else if (e.getActionCommand().equals("showAppHelp")) {
            this.showFile("doc/Crossover.pdf");
        } else if (e.getActionCommand().equals("showManual")) {
            this.showURL("http://cran.at.r-project.org/web/packages/gMCP/gMCP.pdf");
        } else if (e.getActionCommand().equals("showReferences")) {
            this.showFile("References.html");
        } else if (e.getActionCommand().equals("showEpsDoc")) {
            this.showFile("doc/EpsilonEdges.pdf");
        } else if (e.getActionCommand().equals("showNEWS")) {
            new TextFileViewer(this.control, new File(RControl.getR().eval("system.file(\"NEWS\", package=\"Crossover\")").asRChar().getData()[0]));
        } else if (e.getActionCommand().equals("showAbout")) {
            new AboutDialog(this.control);
        } else if (e.getActionCommand().equals("showOptions")) {
            new OptionsDialog(this.control);
        } else if (e.getActionCommand().equals("clearOptions")) {
            Configuration.getInstance().clearConfiguration();
            this.control.repaint();
        } else if (e.getActionCommand().equals("debugConsole")) {
            RControl.console.setVisible(true);
        }
    }

    private void showURL(String url) {
        block2: {
            try {
                Method main = Class.forName("java.awt.Desktop").getDeclaredMethod("getDesktop", new Class[0]);
                Object obj = main.invoke((Object)new Object[0], new Object[0]);
                Method second = obj.getClass().getDeclaredMethod("browse", URI.class);
                second.invoke(obj, new URI(url));
            }
            catch (Exception exc) {
                logger.warn((Object)"No Desktop class in Java 5 or URI error.");
                RControl.getR().eval("browseURL(\"" + url + "\")");
                if (System.getProperty("eclipse") == null) break block2;
                exc.printStackTrace();
            }
        }
    }

    private void notYetSupported() {
        JOptionPane.showMessageDialog(this.control, "Not yet supported.", "Not yet supported", 1);
    }

    public void showFile(String s) {
        block11: {
            File f = new File(RControl.getR().eval("system.file(\"" + s + "\", package=\"Crossover\")").asRChar().getData()[0]);
            if (OSTools.isWindows() && s.indexOf(46) == -1) {
                try {
                    f = FileTransfer.copyFile((File)f, (File)new File(System.getProperty("java.io.tmpdir"), f.getName() + "TXT"));
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this.control, "Please open and read the following file:\n" + f.getAbsolutePath(), "Could not find appropriate viewer", 2);
                }
            }
            if (!f.exists()) {
                throw new RuntimeException("This is strange. The file \"" + s + "\" could not be found.\nFull path: " + f.getAbsolutePath());
            }
            try {
                Method main = Class.forName("java.awt.Desktop").getDeclaredMethod("getDesktop", new Class[0]);
                Object obj = main.invoke((Object)new Object[0], new Object[0]);
                Method second = obj.getClass().getDeclaredMethod("open", File.class);
                second.invoke(obj, f);
            }
            catch (Exception exc) {
                logger.warn((Object)"No Desktop class in Java 5 or URI error.");
                if (f.getName().toLowerCase().endsWith(".html") || f.getName().toLowerCase().endsWith(".htm")) {
                    RControl.getR().eval("browseURL(\"file://" + f.getAbsolutePath().replace('\\', '/') + "\")");
                    return;
                }
                try {
                    if (OSTools.isWindows()) {
                        Process p = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler \"" + f.getAbsolutePath() + "\"");
                        p.waitFor();
                    } else {
                        JOptionPane.showMessageDialog(this.control, "Please open and read the following file:\n" + f.getAbsolutePath(), "Could not find appropriate viewer", 2);
                    }
                }
                catch (Exception e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                    JOptionPane.showMessageDialog(this.control, "Please open and read the following file:\n" + f.getAbsolutePath(), "Could not find appropriate viewer", 2);
                    if (System.getProperty("eclipse") == null) break block11;
                    e1.printStackTrace();
                }
            }
        }
    }

    protected JMenuItem makeMenuItem(String text, String action) {
        return this.makeMenuItem(text, action, true);
    }

    protected JMenuItem makeMenuItem(String text, String action, boolean enabled) {
        JMenuItem item = new JMenuItem(text);
        item.setActionCommand(action);
        item.setEnabled(enabled);
        item.addActionListener(this);
        return item;
    }

    public void loadGraph(String object) {
    }
}

