% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,CrossoverSearchResult,missing-method}
\title{Plots information about the search algorithm and its process.}
\usage{
\S4method{plot}{CrossoverSearchResult,missing}(x, y, type = 1,
  show.jumps = FALSE)
}
\arguments{
\item{x}{Result from searchCrossOverDesign.}

\item{y}{Missing.}

\item{type}{Type of plot. Number 1 is
more colorful, but number 2 perhaps a bit easier to understand.}

\item{show.jumps}{If \code{TRUE} vertical lines will show where the specified
jumps occured.}
}
\value{
Returns a ggplot object of the plot.
}
\description{
Plots information about the search algorithm and its process.
}
\details{
The x-axis corresponds to the consecutive simulation runs and the y-axis to
the design criterion \var{E} that depending on the model is either a
weighted average of efficiency factors or standardized pairwise variances
and described in detail in the vignette of this package.  Also see the
vignette for a few examples and a discussion what can be derived from this
plots.
}
\examples{
\dontrun{
x <- searchCrossOverDesign(s=9, p=5, v=4, model=4)
plot(x)
}

x <- searchCrossOverDesign(s=9, p=5, v=4, model=4, n=c(50,10), jumps=c(10, 10))
plot(x, show.jumps=TRUE)
plot(x, type=2)
}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}

