/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.af.commons.widgets.ComponentTitledBorder;
import org.jdesktop.swingworker.SwingWorker;
import org.mutoss.config.ClassConfig;
import org.mutoss.config.Configuration;
import org.mutoss.gui.CrossoverGUI;
import org.mutoss.gui.Design;
import org.mutoss.gui.HTMLOutputPane;
import org.mutoss.gui.RControl;
import org.mutoss.gui.VariableNameDialog;
import org.mutoss.gui.dialogs.TextFileViewer;

public class AlgorithmPanel
extends JPanel
implements ActionListener,
ChangeListener {
    JTextField jtTitle = new JTextField();
    JTextField jtReference = new JTextField();
    JTextField jtN1 = new JTextField("5000", 6);
    JTextField jtN2 = new JTextField("25", 6);
    JTextField jtRatio = new JTextField("1", 6);
    JButton ok = new JButton("Ready");
    JButton jbCompute = new JButton("Compute Design");
    public HTMLOutputPane jta;
    JLabel label = new JLabel();
    JPanel ntPanel = null;
    JPanel effPanel = null;
    List<JTextField> effV = new Vector<JTextField>();
    List<JTextField> nV = new Vector<JTextField>();
    CellConstraints cc = new CellConstraints();
    JRadioButton jbBalanceNothing = new JRadioButton("No balancing restrictions");
    JRadioButton jbBalanceSequences = new JRadioButton("Balance treatments in regard to sequences");
    JRadioButton jbBalancePeriods = new JRadioButton("Balance treatments in regard to periods");
    CrossoverGUI gui;
    JButton exportR = new JButton("Export to R");
    JButton showAlgoPerformance = new JButton("Search algorithm plot");
    JCheckBox useCatalogueDesigns = new JCheckBox("Use designs from catalogue as starting point");
    JComboBox jcbContrasts = new JComboBox<String>(new String[]{"All pair comparisons (Tukey)", "Comparing treatment 1 to each of the others (Dunnett)"});
    String[] contrasts = new String[]{"Tukey", "Dunnett", "User defined"};
    JComboBox jcbCorrelation = new JComboBox<String>(new String[]{"Independence", "Autoregressive Error", "Equicorrelated Error"});
    String[] correlations = new String[]{"NULL", "autoregressive", "equicorrelated", "user defined"};
    JCheckBox fixedNumber = new JCheckBox("Specify exact number of treatment assignments:");
    JCheckBox fixedSubjectEffects = new JCheckBox("Include fixed subject effects in design matrix.");
    JLabel jlMixed;
    JLabel jlCor;
    JLabel jlVar;
    JTextField jtWithinSubjectRho;
    JSplitPane pane;
    ClassConfig ac = new ClassConfig(Configuration.getInstance(), AlgorithmPanel.class);
    JSpinner spinnerS;
    JPanel lsPanel;
    private int rowN;
    private int rowEff;
    String command = "";
    String models = "";

    public AlgorithmPanel(CrossoverGUI gui) {
        this.gui = gui;
        this.jta = new HTMLOutputPane(gui);
        this.jta.setFont(new Font("Monospaced", 0, 12));
        this.jta.setEditable(false);
        this.pane = new JSplitPane(1, new JScrollPane(this.getLeftSidePanel()), this.getRightSidePanel());
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.pane, c);
        this.loadDefaults();
        gui.spinnerT.addChangeListener(this);
        gui.spinnerP.addChangeListener(this);
        this.spinnerS.addChangeListener(this);
        this.jcbCorrelation.addActionListener(this);
    }

    public JPanel getRightSidePanel() {
        JPanel panel = new JPanel();
        String cols = "5dlu, pref, 5dlu, fill:min:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:min:grow, 5dlu, pref, 5dlu";
        panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        panel.add((Component)new JLabel("Created Design"), cc.xy(2, row));
        panel.add((Component)new JScrollPane(this.jta), cc.xyw(2, row += 2, 3));
        this.jta.setEditable(true);
        panel.add((Component)this.exportR, cc.xy(2, row += 2));
        this.exportR.setEnabled(false);
        this.exportR.addActionListener(this);
        panel.add((Component)this.showAlgoPerformance, cc.xy(4, row));
        this.showAlgoPerformance.setEnabled(false);
        this.showAlgoPerformance.addActionListener(this);
        return panel;
    }

    public void loadDefaults() {
        this.jcbCorrelation.setSelectedIndex(this.ac.getIntProperty("CVPattern", 0));
        this.jtWithinSubjectRho.setText(this.ac.getProperty("cpc", "0.5"));
        boolean mixed = this.jcbCorrelation.getSelectedIndex() == 1 || this.jcbCorrelation.getSelectedIndex() == 2;
        this.jtWithinSubjectRho.setEnabled(mixed);
        this.jlMixed.setEnabled(mixed);
        this.spinnerS.getModel().setValue(this.ac.getIntProperty("s", 4));
        this.fixedSubjectEffects.setSelected(this.ac.getBoolProperty("fixedSubjectEffects", true));
        for (int i = 0; i < this.nV.size(); ++i) {
            this.nV.get(i).setText(this.ac.getProperty("nV" + i, ""));
        }
        this.jbBalanceNothing.setSelected(this.ac.getBoolProperty("jbBalanceNothing", true));
        this.jbBalanceSequences.setSelected(this.ac.getBoolProperty("jbBalanceSequences", false));
        this.jbBalancePeriods.setSelected(this.ac.getBoolProperty("jbBalancePeriods", false));
        int contrast = this.ac.getIntProperty("contrast", 0);
        try {
            this.jcbContrasts.setSelectedIndex(contrast);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.useCatalogueDesigns.setSelected(this.ac.getBoolProperty("catalogue", false));
        this.jtN2.setText(this.ac.getProperty("nRuns", "20"));
        this.jtN1.setText(this.ac.getProperty("nSteps", "5000"));
    }

    public void saveDefaults() {
        int i;
        this.ac.setIntProperty("CVPattern", this.jcbCorrelation.getSelectedIndex());
        this.ac.setProperty("cpc", this.jtWithinSubjectRho.getText());
        this.ac.setIntProperty("s", Integer.parseInt(this.spinnerS.getModel().getValue().toString()));
        this.ac.setBoolProperty("fixedNumber", this.fixedNumber.isSelected());
        this.ac.setBoolProperty("fixedSubjectEffects", this.fixedSubjectEffects.isSelected());
        for (i = 0; i < this.nV.size(); ++i) {
            this.ac.setProperty("nV" + i, this.nV.get(i).getText());
        }
        this.ac.setBoolProperty("jbBalanceNothing", this.jbBalanceNothing.isSelected());
        this.ac.setBoolProperty("jbBalanceSequences", this.jbBalanceSequences.isSelected());
        this.ac.setBoolProperty("jbBalancePeriods", this.jbBalancePeriods.isSelected());
        this.ac.setIntProperty("contrast", this.jcbContrasts.getSelectedIndex());
        for (i = 0; i < this.effV.size(); ++i) {
            this.ac.setProperty("effV" + i, this.effV.get(i).getText());
        }
        this.ac.setBoolProperty("catalogue", this.useCatalogueDesigns.isSelected());
        this.ac.setProperty("nRuns", this.jtN2.getText());
        this.ac.setProperty("nSteps", this.jtN1.getText());
    }

    public JPanel getLeftSidePanel() {
        this.lsPanel = new JPanel();
        String cols = "5dlu, pref, 5dlu, fill:min:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        this.lsPanel.setLayout((LayoutManager)new FormLayout(cols, rows));
        int row = 2;
        this.jlCor = new JLabel("Covariance pattern");
        this.lsPanel.add((Component)this.jlCor, this.cc.xy(2, row));
        this.lsPanel.add((Component)this.jcbCorrelation, this.cc.xy(4, row));
        this.jlMixed = new JLabel("Covariance pattern coefficient");
        this.jlMixed.setEnabled(false);
        this.jtWithinSubjectRho = new JTextField("0.5");
        this.jtWithinSubjectRho.setEnabled(false);
        this.lsPanel.add((Component)this.jlMixed, this.cc.xy(2, row += 2));
        this.lsPanel.add((Component)this.jtWithinSubjectRho, this.cc.xy(4, row));
        this.lsPanel.add((Component)this.fixedSubjectEffects, this.cc.xyw(2, row += 2, 3));
        this.spinnerS = new JSpinner(new SpinnerNumberModel(5, 1, 100, 1));
        this.lsPanel.add((Component)new JLabel("Number of sequences:"), this.cc.xy(2, row += 2));
        this.lsPanel.add((Component)this.spinnerS, this.cc.xy(4, row));
        this.rowN = row += 2;
        this.createTreatmentNumberPanel(true);
        row += 2;
        ButtonGroup group = new ButtonGroup();
        group.add(this.jbBalanceNothing);
        group.add(this.jbBalanceSequences);
        this.jbBalanceSequences.setToolTipText("May decrease efficiency");
        group.add(this.jbBalancePeriods);
        this.jbBalancePeriods.setToolTipText("May decrease efficiency");
        this.jbBalanceNothing.setSelected(true);
        this.lsPanel.add((Component)this.jbBalanceNothing, this.cc.xyw(2, row, 3));
        this.lsPanel.add((Component)this.jbBalanceSequences, this.cc.xyw(2, row += 2, 3));
        this.lsPanel.add((Component)this.jbBalancePeriods, this.cc.xyw(2, row += 2, 3));
        this.lsPanel.add((Component)new JLabel("Contrasts:"), this.cc.xy(2, row += 2));
        this.lsPanel.add((Component)this.jcbContrasts, this.cc.xyw(2, row += 2, 3));
        this.rowEff = row += 2;
        this.createEffPanel();
        this.useCatalogueDesigns.setSelected(true);
        this.lsPanel.add((Component)this.useCatalogueDesigns, this.cc.xyw(2, row += 2, 3));
        this.lsPanel.add((Component)new JLabel("Number of search runs:"), this.cc.xy(2, row += 2));
        this.lsPanel.add((Component)this.jtN2, this.cc.xy(4, row));
        this.lsPanel.add((Component)new JLabel("Number of steps per run:"), this.cc.xy(2, row += 2));
        this.lsPanel.add((Component)this.jtN1, this.cc.xy(4, row));
        this.lsPanel.add((Component)this.jbCompute, this.cc.xyw(2, row += 2, 3));
        this.jbCompute.addActionListener(this);
        return this.lsPanel;
    }

    public void createEffPanel() {
        int i;
        if (this.effPanel != null) {
            this.lsPanel.remove(this.effPanel);
        }
        this.effPanel = new JPanel();
        GridBagConstraints effWeights = new GridBagConstraints();
        effWeights.fill = 1;
        effWeights.gridx = 0;
        effWeights.gridy = 0;
        effWeights.gridwidth = 1;
        effWeights.gridheight = 1;
        effWeights.ipadx = 5;
        effWeights.ipady = 5;
        effWeights.weightx = 1.0;
        effWeights.weighty = 1.0;
        this.effPanel.setBorder(BorderFactory.createTitledBorder("Weights:"));
        this.effPanel.setLayout(new GridBagLayout());
        Vector<String> labels = new Vector<String>();
        int s = this.gui.jCBmodel.getSelectedIndex();
        for (String p : CrossoverGUI.parameters[s]) {
            labels.add(p);
        }
        this.effV.clear();
        for (i = 0; i < labels.size(); ++i) {
            this.effV.add(new JTextField("1.0", 6));
            this.effPanel.add((Component)new JLabel((String)labels.get(i)), effWeights);
            ++effWeights.gridx;
            this.effPanel.add((Component)this.effV.get(i), effWeights);
            if ((i + 1) % 3 != 0) {
                ++effWeights.gridx;
                continue;
            }
            effWeights.gridx = 0;
            ++effWeights.gridy;
        }
        if (labels.size() == 0) {
            this.effPanel.add((Component)new JLabel("Not applicable."), effWeights);
        }
        for (i = 0; i < this.effV.size(); ++i) {
            this.effV.get(i).setText(this.ac.getProperty("effV" + i, i == 0 ? "1" : "0"));
        }
        this.lsPanel.add((Component)this.effPanel, this.cc.xyw(2, this.rowEff, 3));
        this.lsPanel.revalidate();
        this.lsPanel.repaint();
    }

    private String getEffFactors() {
        if (this.effV.size() == 0) {
            return "1";
        }
        String s = "c(";
        for (JTextField jt : this.effV) {
            s = s + jt.getText() + ",";
        }
        return s.substring(0, s.length() - 1) + ")";
    }

    private void createTreatmentNumberPanel(boolean firstCall) {
        int i;
        if (this.ntPanel != null) {
            this.lsPanel.remove(this.ntPanel);
        }
        this.ntPanel = new JPanel();
        GridBagConstraints cbcWeights = new GridBagConstraints();
        cbcWeights.fill = 1;
        cbcWeights.gridx = 0;
        cbcWeights.gridy = 0;
        cbcWeights.gridwidth = 1;
        cbcWeights.gridheight = 1;
        cbcWeights.weightx = 1.0;
        cbcWeights.weighty = 1.0;
        cbcWeights.insets = new Insets(2, 2, 2, 2);
        if (firstCall) {
            this.fixedNumber.addActionListener(this);
        }
        this.ntPanel.setBorder((Border)new ComponentTitledBorder((Component)this.fixedNumber, (JComponent)this.ntPanel, (Border)BorderFactory.createTitledBorder("Weights:")));
        this.ntPanel.setLayout(new GridBagLayout());
        Vector<String> labels = new Vector<String>();
        int v = Integer.parseInt(this.gui.spinnerT.getModel().getValue().toString());
        int s = Integer.parseInt(this.spinnerS.getModel().getValue().toString());
        int p = Integer.parseInt(this.gui.spinnerP.getModel().getValue().toString());
        for (i = 1; i <= v; ++i) {
            labels.add(" Treatment " + i + ":");
        }
        this.nV.clear();
        for (i = 0; i < labels.size(); ++i) {
            this.nV.add(new JTextField("" + (s * p / v + (i < s * p % v ? 1 : 0)), 3));
            this.ntPanel.add((Component)new JLabel((String)labels.get(i)), cbcWeights);
            ++cbcWeights.gridx;
            this.ntPanel.add((Component)this.nV.get(i), cbcWeights);
            if ((i + 1) % 3 != 0) {
                ++cbcWeights.gridx;
                continue;
            }
            cbcWeights.gridx = 0;
            ++cbcWeights.gridy;
        }
        boolean fixed = this.ac.getBoolProperty("fixedNumber", false);
        this.fixedNumber.setSelected(fixed);
        this.ntPanel.setEnabled(fixed);
        for (Component c : this.ntPanel.getComponents()) {
            c.setEnabled(fixed);
        }
        this.lsPanel.add((Component)this.ntPanel, this.cc.xyw(2, this.rowN, 3));
        this.lsPanel.revalidate();
        this.lsPanel.repaint();
    }

    private String getVRep() {
        if (!this.fixedNumber.isSelected()) {
            return "";
        }
        String vrep = ", v.rep=c(";
        for (int i = 0; i < this.nV.size(); ++i) {
            vrep = vrep + this.nV.get(i).getText();
            if (i == this.nV.size() - 1) continue;
            vrep = vrep + ",";
        }
        return vrep + ")";
    }

    private String getContrast() {
        return "";
    }

    public void addActionListener(ActionListener al) {
        this.ok.addActionListener(al);
    }

    public Design getDesign() {
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        this.saveDefaults();
        if (e.getSource() == this.jbCompute) {
            this.gui.glassPane.start();
            this.command = "searchCrossOverDesign(s=" + this.spinnerS.getModel().getValue().toString() + ", " + this.gui.getParameters() + ", model=\"" + this.gui.jCBmodel.getSelectedItem() + "\"" + ", eff.factor=" + this.getEffFactors() + ", contrast=\"" + this.contrasts[this.jcbContrasts.getSelectedIndex()] + "\"" + this.getVRep() + ", balance.s=" + (this.jbBalanceSequences.isSelected() ? "TRUE" : "FALSE") + ", balance.p=" + (this.jbBalancePeriods.isSelected() ? "TRUE" : "FALSE") + this.getCorrelation() + (this.gui.jCBmodel.getSelectedIndex() == 3 ? ", model.param=list(placebos=" + this.gui.jtfParam.getText() + ")" : "") + (this.gui.jCBmodel.getSelectedIndex() == 2 ? ", model.param=list(ppp=" + this.gui.jtfParam.getText() + ")" : "") + (this.useCatalogueDesigns.isSelected() ? ", start.designs=\"catalog\"" : "") + ", random.subject=" + (this.fixedSubjectEffects.isSelected() ? "FALSE" : "TRUE") + ", n=c(" + this.jtN1.getText() + "," + this.jtN2.getText() + ")" + ", verbose=FALSE)";
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                protected Void doInBackground() throws Exception {
                    RControl.getR().eval(".COresult <- " + AlgorithmPanel.this.command);
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected final void done() {
                    try {
                        Design design = new Design("Search Result n=(" + AlgorithmPanel.this.jtN1.getText() + "," + AlgorithmPanel.this.jtN2.getText() + "), model=" + AlgorithmPanel.this.gui.jCBmodel.getSelectedIndex() + ", " + new SimpleDateFormat("yyyy-MM-dd kk:mm").format(new Date()), ".COresult", AlgorithmPanel.this.command);
                        AlgorithmPanel.this.gui.dac.addSearchResult(design);
                        this.get();
                        AlgorithmPanel.this.exportR.setEnabled(true);
                        AlgorithmPanel.this.showAlgoPerformance.setEnabled(true);
                        AlgorithmPanel.this.jta.clear();
                        AlgorithmPanel.this.jta.showDesign(design);
                        AlgorithmPanel.this.jta.appendParagraph("Random seed: TODO");
                        AlgorithmPanel.this.jta.appendParagraph("R Code: <pre>" + AlgorithmPanel.this.command + "</pre>");
                        AlgorithmPanel.this.jta.textArea.setCaretPosition(0);
                    }
                    catch (CancellationException e) {
                    }
                    catch (Throwable e) {
                        String message = e.getMessage();
                        if (message.equals("Error: \n")) {
                            message = "Empty message (most likely an error in the C++ code - please look at the R console for further output)\n\n";
                        }
                        JOptionPane.showMessageDialog(AlgorithmPanel.this.gui, "R call produced an error:\n\n" + message + "\nWe will open a window with R code to reproduce this error for investigation.", "Error in R Call", 0);
                        String traceback = RControl.getR().eval("paste(unlist(traceback()),collapse=\"\\n\")").asRChar().getData()[0];
                        JDialog d = new JDialog(AlgorithmPanel.this.gui, "R Error", true);
                        d.add(new TextFileViewer((JFrame)AlgorithmPanel.this.gui, "R Objects", "The following R code produced the following error:\n\n" + message + "\n\nTraceback:\n\n" + traceback + "\n\n" + AlgorithmPanel.this.command, true));
                        d.pack();
                        d.setSize(800, 600);
                        d.setVisible(true);
                        e.printStackTrace();
                    }
                    finally {
                        AlgorithmPanel.this.gui.glassPane.stop();
                    }
                }
            };
            worker.execute();
        } else if (e.getSource() == this.showAlgoPerformance) {
            RControl.getR().eval("JavaGD(\"Search algorithm performance\")");
            RControl.getR().eval("print(plot(.COresult))");
        } else if (e.getSource() == this.exportR) {
            VariableNameDialog vd = new VariableNameDialog(this.gui, "design");
            RControl.getR().eval(vd.getName() + " <- getDesign(.COresult)");
        } else if (e.getSource() == this.jcbCorrelation) {
            boolean mixed = this.jcbCorrelation.getSelectedIndex() == 1 || this.jcbCorrelation.getSelectedIndex() == 2;
            this.jtWithinSubjectRho.setEnabled(mixed);
            this.jlMixed.setEnabled(mixed);
        } else if (e.getSource() == this.fixedNumber) {
            boolean fixed = this.fixedNumber.isSelected();
            this.ntPanel.setEnabled(fixed);
            for (Component c : this.ntPanel.getComponents()) {
                c.setEnabled(fixed);
            }
        }
    }

    private String getCorrelation() {
        if (this.jcbCorrelation.getSelectedIndex() == 0) {
            return "";
        }
        return ", correlation=\"" + this.correlations[this.jcbCorrelation.getSelectedIndex()] + "\", rho=" + this.jtWithinSubjectRho.getText();
    }

    private String getTmpFile() {
        String file = System.getProperty("java.io.tmpdir") + "/searchplot" + new Date().getTime() + ".png";
        System.out.println(file);
        return file;
    }

    public void stateChanged(ChangeEvent e) {
        this.createTreatmentNumberPanel(false);
        int s1 = Integer.parseInt(this.gui.spinnerS1.getModel().getValue().toString());
        int s2 = Integer.parseInt(this.gui.spinnerS2.getModel().getValue().toString());
        int s = Integer.parseInt(this.spinnerS.getModel().getValue().toString());
        if (s < s1) {
            this.gui.spinnerS1.getModel().setValue(s);
        } else if (s > s2) {
            this.gui.spinnerS2.getModel().setValue(s);
        }
    }

    public void searchResultReady(String table) {
        this.exportR.setEnabled(true);
        this.showAlgoPerformance.setEnabled(true);
        this.jta.clear();
        String command2 = "paste(capture.output(general.carryover(.COresult)),collapse=\"\\n\")";
        this.jta.appendParagraph("<pre>" + RControl.getR().eval(command2).asRChar().getData()[0] + "</pre>");
        this.jta.appendParagraph("Random seed: TODO");
        this.jta.appendParagraph("R Code: <pre>" + this.command + "</pre>");
    }
}

