% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{helper_functions}
\alias{helper.channel_ids_from_long_names}
\alias{helper.filter_names_to_ids_from_df}
\alias{helper_functions}
\title{Helper Functions}
\usage{
helper.filter_names_to_ids_from_df(ids_names_df, names_array = c("*"))

helper.channel_ids_from_long_names(panels_list, fcs_files, long_channel_names)
}
\arguments{
\item{ids_names_df}{dataframe containing both IDs and their associated names}

\item{names_array}{vector or list of character regular expressions to use}

\item{panels_list}{list provided from the \link[=panels]{panels.list} endpoint}

\item{fcs_files}{vector of integers representing a list of FCS file IDs}

\item{long_channel_names}{vector of character representing long channel names}
}
\description{
Various helper functions to utilize within the Cytobank API.
}
\details{
\code{helper.filter_names_to_ids_from_df} Compile a vector of IDs from an array of regular expressions.

\code{helper.channel_ids_from_long_names} Compile a vector of IDs from an array of regular expressions.
}
\examples{
\donttest{helper.filter_names_to_ids_from_df(id_and_names_dataframe, names_list=c("CD.*", "Time", "pp38"))
}
\donttest{helper.channel_ids_from_long_names(panels.list(cyto_session, 22),
  fcs_files=c(1,2,3,4,5), long_channel_names=c("long_channel1", "long_channel2"))
}
}

