% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\docType{methods}
\name{scales}
\alias{scales}
\alias{scales.list,UserSession-method}
\alias{scales.list}
\alias{scales.show,UserSession-method}
\alias{scales.show}
\alias{scales.update,UserSession-method}
\alias{scales.update}
\title{Scale Endpoints}
\usage{
\S4method{scales.list}{UserSession}(UserSession, experiment_id,
  output = "default", timeout = UserSession@short_timeout)

\S4method{scales.show}{UserSession}(UserSession, experiment_id, scale_id,
  output = "default", timeout = UserSession@short_timeout)

\S4method{scales.update}{UserSession}(UserSession, scale, output = "default",
  timeout = UserSession@short_timeout)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{output}{character representing the output format \strong{[optional]}\cr
\emph{- scales.list, scales.show, scales.update : \code{("default", "raw")}}}

\item{timeout}{integer representing the request timeout time in seconds}

\item{scale_id}{integer representing a scale ID}

\item{scale}{dataframe representing a scale}
}
\description{
Interact with scale endpoints. Data are rarely presented exactly as they were acquired on the instrument. \href{https://support.cytobank.org/hc/en-us/categories/200260637-Data-Scaling-and-Transformation}{Learn more about data scaling}.
}
\details{
\code{scales.list} List all scales from an experiment. Outputs a dataframe [default] or raw list with all fields present.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{scales.show} Show scale details from an experiment.
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{scales.update} Update a single scale from an experiment.
(all parameters are optional, except for experiment_id and scale_id)\cr
\emph{- Scale Types -- }\code{1: Linear, 2: Log, 4: Arcsinh}\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}
}
\examples{
\donttest{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
\donttest{# Dataframe of all scales with all fields present
scales.list(cyto_session, 22)

# Raw list of all scales with all fields present
scales.list(cyto_session, 22, output="raw")
}
\donttest{scales.show(cyto_session, 22, scale_id=2)
}
\donttest{# Update any number of parameters (scale_type, cofactor, minimum, maximum)
# Scale Types -- 1: Linear, 2: Log, 4: Arcsinh
scales.update(cyto_session, scale=cyto_scale)
}
}
