% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzedata.R
\name{analyzedata}
\alias{analyzedata}
\title{Returns a matrix of event counts or raw medians, as specified by inputs. Columns correspond to fcs files and rows to markers in cell types}
\usage{
analyzedata(cyto_session, markersofinterest, popsofinterest, exptID, type)
}
\arguments{
\item{cyto_session}{- API authentication token for session}

\item{markersofinterest}{- Names of channel parameters in Cytobank as list of strings}

\item{popsofinterest}{- Names of gates of interest in Cytobank as list of strings}

\item{exptID}{- Integer representing an experiment ID on Cytobank account}

\item{type}{- boolean with TRUE to analyze events, FALSE to analyze marker intensity statistics}
}
\value{
Returns a data matrix of event counts or raw signal medians, as specified by variable type
}
\description{
Returns a matrix of event counts or raw medians, as specified by inputs. Columns correspond to fcs files and rows to markers in cell types
}
\examples{
\donttest{
library(CytobankAPI)
cyto_session <- authenticate(site="premium", username="myusername", password="mypassword")
markersofinterest<-c("CD3","CD56")
popsofinterest<-c("CD4 T cells","NK cells")
exptID=4
type=TRUE
analyzedata(cyto_session,markersofinterest,popsofinterest,exptID,type)}
}
