% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{compute,D2C.network-method}
\alias{compute,D2C.network-method}
\alias{compute}
\title{compute N samples according to the network distribution}
\usage{
\S4method{compute}{D2C.network}(object, N = 50)
}
\arguments{
\item{object}{a D2C.network object}

\item{N}{numeric. the number of samples generated according to the network}
}
\value{
a N*nNodes matrix
}
\description{
compute N samples according to the network distribution
}
\examples{
\dontrun{
require(RBGL)
require(gRbase)
N=150
DAG = new("D2C.network",network=random_dag(1:50,maxpar = 5,wgt=0.8))
X = compute(DAG,N=N)
plot(DAG@network)}
}

