% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{initialize,D2C-method}
\alias{initialize,D2C-method}
\title{creation of a D2C object which preprocesses the list of DAGs and observations contained in sDAG and fits a  Random Forest classifier}
\usage{
\S4method{initialize}{D2C}(.Object, sDAG, descr = new("D2C.descriptor"),
  verbose = TRUE, ratioMissingNode = 0, ratioEdges = 1,
  max.features = 20)
}
\arguments{
\item{.Object}{: the D2C object}

\item{sDAG}{: simulateDAG object}

\item{descr}{: D2C.descriptor object containing the parameters of the descriptor}

\item{verbose}{: if TRUE it prints the state of progress}

\item{ratioMissingNode}{: percentage of existing nodes which are not considered. This is used to emulate latent variables.}

\item{ratioEdges}{: percentage of existing edges which are added to the training set}

\item{max.features}{: maximum number of features used by the Random Forest classifier \link[randomForest]{randomForest}. The features are selected by the importance returned by the function \link[randomForest]{importance}.}
}
\description{
creation of a D2C object which preprocesses the list of DAGs and observations contained in sDAG and fits a  Random Forest classifier
}
\examples{
require(RBGL)
require(gRbase)
descr=new("D2C.descriptor")
descr.example<-new("D2C.descriptor",bivariate=FALSE,ns=3,acc=TRUE)
trainDAG<-new("simulatedDAG",NDAG=2, N=50,noNodes=10,
             functionType = "linear", seed=0,sdn=0.5)
example<-new("D2C",sDAG=trainDAG, descr=descr.example)
}
\references{
Gianluca Bontempi, Maxime Flauder (2014) From dependency to causality: a machine learning approach. Under submission
}

