% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taskArchive.R
\name{restoreTask}
\alias{restoreTask}
\title{Restore an archive containing the files of a given task from a file created with archiveTask.}
\usage{
restoreTask(file, overwrite = FALSE, list = FALSE, code = TRUE, ...)
}
\arguments{
\item{file}{full name of the input zip file}

\item{overwrite}{If \code{TRUE}, overwrite existing files (the equivalent
    of \command{unzip -o}), otherwise ignore such files (the equivalent of
    \command{unzip -n}).}

\item{list}{If \code{TRUE}, list the files and extract none.  The
    equivalent of \command{unzip -l}.}

\item{code}{restore code, default TRUE}

\item{...}{
  Arguments passed on to \code{\link[utils:unzip]{utils::unzip}}
  \describe{
    \item{\code{zipfile}}{The pathname of the zip file: tilde expansion (see
    \code{\link{path.expand}}) will be performed.}
    \item{\code{files}}{A character vector of recorded filepaths to be extracted:
    the default is to extract all files.}
    \item{\code{junkpaths}}{If \code{TRUE}, use only the basename of the stored
    filepath when extracting.  The equivalent of \command{unzip -j}.}
    \item{\code{exdir}}{The directory to extract files to (the equivalent of
    \code{unzip -d}).  It will be created if necessary.}
    \item{\code{unzip}}{The method to be used.  An alternative is to use
    \code{getOption("unzip")}, which on a Unix-alike may be set to the
    path to a \command{unzip} program.}
    \item{\code{setTimes}}{logical.  For the internal method only, should the
    file times be set based on the times in the zip file?  (NB: this
    applies to included files, not to directories.)}
  }}
}
\value{
if list FALSE, the task imported incisibly, otherwise the list of files in the archive.
}
\description{
Restore an archive containing the files of a given task from a file created with archiveTask.
}
