% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_plot_age_diversity.R
\name{DAISIE_plot_age_diversity}
\alias{DAISIE_plot_age_diversity}
\title{Plot clade age against clade diversity.}
\usage{
DAISIE_plot_age_diversity(
  island,
  title = "Clade age vs clade diversity",
  island_age = NA
)
}
\arguments{
\item{island}{Island data object. Can be in DAISIE list format (see
Galapagos_datalist and DAISIE_data_prep for examples) or in table format
(see Galapagos_datatable for an example).}

\item{title}{Title of the plot}

\item{island_age}{Age of island in appropriate units. In
\code{\link{DAISIE_plot_age_diversity}()} and
\code{\link{DAISIE_plot_island}()} if island input is in table format,
the age of the island must be specified. If island input is in DAISIE list
format, this option will override the island age specified in the island
list.}
}
\value{
R plot.
}
\description{
Plots clade age against clade diversity for all clades for which
colonisation time is known.
}
\details{
R plot showing for each clade in the island object the time of colonisation
and the diversity of the clade. Only clades for which colonisation time is
known are plotted. Blue - endemic; black - non-endemic. C = number of
independent colonisations on island, N = number of species on the island
}
\examples{


### Plot Galapagos age-diversity for Galapagos dataset
utils::data(Galapagos_datalist)
DAISIE_plot_age_diversity(Galapagos_datalist)


}
\references{
Valente, L.M., A.B. Phillimore and R.S. Etienne (2015).
Equilibrium and non-equilibrium dynamics simultaneously operate in the
Galapagos islands. Ecology Letters 18: 844-852.
}
\seealso{
\code{\link{DAISIE_sim_constant_rate}},
\code{\link{DAISIE_sim_time_dependent}},
\code{\link{DAISIE_sim_constant_rate_shift}},
\code{\link{DAISIE_plot_island}}
}
\author{
Luis Valente
}
\keyword{models}
