% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_descendants_conspecific.R
\name{all_descendants_conspecific}
\alias{all_descendants_conspecific}
\title{Checks whether all species given in the descendants vector are the same
species.}
\usage{
all_descendants_conspecific(descendants)
}
\arguments{
\item{descendants}{A vector character strings with the names of species to
determine whether they are the same species.}
}
\value{
Boolean
}
\description{
Checks whether all species given in the descendants vector are the same
species.
}
\examples{
# Example where species are not conspecific
descendants <- c("bird_a", "bird_b", "bird_c")
all_descendants_conspecific(descendants = descendants)

# Example where species are conspecific
descendants <- c("bird_a_1", "bird_a_2", "bird_a_3")
all_descendants_conspecific(descendants = descendants)
}
