% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_explainer.R
\name{print.explainer}
\alias{print.explainer}
\title{Print Explainer Summary}
\usage{
\method{print}{explainer}(x, ...)
}
\arguments{
\item{x}{a model explainer created with the `explain` function}

\item{...}{other parameters}
}
\description{
Print Explainer Summary
}
\examples{

aps_lm_model4 <- lm(m2.price~., data = apartments)
aps_lm_explainer4 <- explain(aps_lm_model4, data = apartments, y = apartments$m2.price,
                             label = "model_4v")
aps_lm_explainer4

 \dontrun{
library("ranger")
titanic_ranger_model <- ranger(survived~., data = titanic_imputed, num.trees = 50,
                               probability = TRUE)
explainer_ranger  <- explain(titanic_ranger_model, data = titanic_imputed[,-8],
                             y = titanic_imputed$survived,
                             label = "model_ranger")
explainer_ranger
 }

}
