% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_variable_effect.R
\name{variable_effect}
\alias{variable_effect}
\alias{variable_effect_partial_dependency}
\alias{variable_effect_accumulated_dependency}
\title{Dataset Level Variable Effect as Partial Dependency Profile or Accumulated Local Effects}
\usage{
variable_effect(explainer, variables, ..., type = "partial_dependency")

variable_effect_partial_dependency(explainer, variables, ...)

variable_effect_accumulated_dependency(explainer, variables, ...)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the 'explain' function}

\item{variables}{character - names of variables to be explained}

\item{...}{other parameters}

\item{type}{character - type of the response to be calculated.
Currently following options are implemented: 'partial_dependency' for Partial Dependency and 'accumulated_dependency' for Accumulated Local Effects}
}
\value{
An object of the class 'aggregated_profiles_explainer'.
It's a data frame with calculated average response.
}
\description{
From DALEX version 1.0 this function calls the \code{\link[ingredients]{accumulated_dependence}} or
\code{\link[ingredients]{partial_dependence}} from the \code{ingredients} package.
Find information how to use this function here: \url{https://pbiecek.github.io/ema/partialDependenceProfiles.html}.
}
\examples{
titanic_glm_model <- glm(survived~., data = titanic_imputed, family = "binomial")
explainer_glm <- explain(titanic_glm_model, data = titanic_imputed)
expl_glm <- variable_effect(explainer_glm, "fare", "partial_dependency")
plot(expl_glm)

 \donttest{
library("ranger")
titanic_ranger_model <- ranger(survived~., data = titanic_imputed, num.trees = 50,
                               probability = TRUE)
explainer_ranger  <- explain(titanic_ranger_model, data = titanic_imputed)
expl_ranger  <- variable_effect(explainer_ranger, variables = "fare",
                            type = "partial_dependency")
plot(expl_ranger)
plot(expl_ranger, expl_glm)

# Example for factor variable (with factorMerger)
expl_ranger_factor  <- variable_effect(explainer_ranger, variables =  "class")
plot(expl_ranger_factor)
 }

}
\references{
Explanatory Model Analysis. Explore, Explain, and Examine Predictive Models. \url{https://pbiecek.github.io/ema/}
}
