\name{balsos}
\alias{balsos}
\title{Bayesian Alternating Least Squares Optimal Scaling}
\description{Estimates a Bayesian analog to the the Alternating Least Squares Optimal Scaling (ALSOS) solution for qualitative dependent variables.}
\usage{
	balsos(formula, data, iter=2500, chains = 1, 
    alg = c("NUTS", "HMC", "Fixed_param"), ...)
}
\arguments{
  \item{formula}{A formula with a dependent variable that will be optimally scaled}

  \item{data}{A data frame.}

  \item{iter}{Number of samples for the MCMC sampler.}

  \item{chains}{Number of parallel chains to be run. }

  \item{alg}{Algorithm used to do sampling.  See \code{\link{stan}} for more details. }
  
  \item{...}{Other arguments to be passed down to \code{stanfit}.}
}
\details{
\code{balsos} estimates a Bayesian analog to the Alternating Least Squares Optimal Scaling solution on the dependent variable.  This permits testing linearity assumptions on the original scale of the dependent variable. 
}
\value{
A list with the following elements: 

\item{fit}{The fitted stan output}

\item{y}{The dependent variable values used in the regression. }

\item{X}{The design matrix for the regression}
}
\references{

Jacoby, William G.  1999.  \sQuote{Levels of Measurement and Political Research: An Optimistic View}  American Journal of Political Science  43(1): 271-301.

Young, Forrest.  1981.  \sQuote{Quantitative Analysis of Qualitative Data}  Psychometrika, 46: 357-388.

Young, Forrest, Jan de Leeuw and Yoshio Takane.  1976.  \sQuote{Regression with Qualitative and Quantitative Variables: An Alternating Least Squares Method with Optimal Scaling Features}  Psychometrika, 41:502-529.

}
\author{Dave Armstrong}
