% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBResult.R
\name{dbFetch}
\alias{dbFetch}
\alias{fetch}
\title{Fetch records from a previously executed query}
\usage{
dbFetch(res, n = -1, ...)

fetch(res, n = -1, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}, created by
\code{\link[=dbSendQuery]{dbSendQuery()}}.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{n = -1}
or \code{n = Inf}
to retrieve all pending records.  Some implementations may recognize other
special values.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbFetch()} always returns a \link{data.frame}
with as many rows as records were fetched and as many
columns as fields in the result set,
even if the result is a single value
or has one
or zero rows.
An attempt to fetch from a closed result set raises an error.
If the \code{n} argument is not an atomic whole number
greater or equal to -1 or Inf, an error is raised,
but a subsequent call to \code{dbFetch()} with proper \code{n} argument succeeds.
Calling \code{dbFetch()} on a result set from a data manipulation query
created by \code{\link[=dbSendStatement]{dbSendStatement()}}
can be fetched and return an empty data frame, with a warning.
}
\description{
Fetch the next \code{n} elements (rows) from the result set and return them
as a data.frame.
}
\details{
\code{fetch()} is provided for compatibility with older DBI clients - for all
new code you are strongly encouraged to use \code{dbFetch()}. The default
implementation for \code{dbFetch()} calls \code{fetch()} so that it is compatible with
existing code. Modern backends should implement for \code{dbFetch()} only.
}
\section{Specification}{


Fetching multi-row queries with one
or more columns be default returns the entire result.
Multi-row queries can also be fetched progressively
by passing a whole number (\link{integer}
or \link{numeric})
as the \code{n} argument.
A value of \link{Inf} for the \code{n} argument is supported
and also returns the full result.
If more rows than available are fetched, the result is returned in full
without warning.
If fewer rows than requested are returned, further fetches will
return a data frame with zero rows.
If zero rows are fetched, the columns of the data frame are still fully
typed.
Fetching fewer rows than available is permitted,
no warning is issued when clearing the result set.




The column types of the returned data frame depend on the data returned:
\itemize{
\item \link{integer} for integer values between -2^31 and 2^31 - 1
\item \link{numeric} for numbers with a fractional component
\item \link{logical} for Boolean values (some backends may return an integer)
\item \link{character} for text
\item lists of \link{raw} for blobs (with \code{NULL} entries for SQL NULL values)
\item coercible using \code{\link[=as.Date]{as.Date()}} for dates
(also applies to the return value of the SQL function \code{current_date})
\item coercible using \code{\link[hms:as.hms]{hms::as.hms()}} for times
(also applies to the return value of the SQL function \code{current_time})
\item coercible using \code{\link[=as.POSIXct]{as.POSIXct()}} for timestamps
(also applies to the return value of the SQL function \code{current_timestamp})
\item \link{NA} for SQL \code{NULL} values
}

If dates and timestamps are supported by the backend, the following R types are
used:
\itemize{
\item \link{Date} for dates
(also applies to the return value of the SQL function \code{current_date})
\item \link{POSIXct} for timestamps
(also applies to the return value of the SQL function \code{current_timestamp})
}

R has no built-in type with lossless support for the full range of 64-bit
or larger integers. Here, the following rules apply:
\itemize{
\item Values are returned as numeric
\item Conversion to character always returns a lossless decimal representation
of the data
}

}

\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)

# Fetch all results
rs <- dbSendQuery(con, "SELECT * FROM mtcars WHERE cyl = 4")
dbFetch(rs)
dbClearResult(rs)

# Fetch in chunks
rs <- dbSendQuery(con, "SELECT * FROM mtcars")
while (!dbHasCompleted(rs)) {
  chunk <- dbFetch(rs, 10)
  print(nrow(chunk))
}

dbClearResult(rs)
dbDisconnect(con)
}
\seealso{
Close the result set with \code{\link[=dbClearResult]{dbClearResult()}} as soon as you
finish retrieving the records you want.

Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsValid}},
  \code{\link{dbQuoteIdentifier}},
  \code{\link{dbQuoteString}}
}
