% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R, R/spec-getting-started.R,
%   R/spec-compliance-methods.R, R/spec-driver-constructor.R, R/spec-driver.R,
%   R/spec-connection.R, R/spec-result.R, R/spec-sql.R, R/spec-meta.R,
%   R/spec-transaction.R, R/spec-compliance.R, R/spec-stress.R
\docType{data}
\name{DBIspec}
\alias{DBIspec}
\title{DBI specification}
\description{
Placeholder page.
}
\section{Definition}{

A DBI backend is an R package
which imports the \pkg{DBI}
and \pkg{methods}
packages.
For better or worse, the names of many existing backends start with
\sQuote{R}, e.g., \pkg{RSQLite}, \pkg{RMySQL}, \pkg{RSQLServer}; it is up
to the backend author to adopt this convention or not.
}

\section{DBI classes and methods}{

A backend defines three classes,
which are subclasses of
\linkS4class{DBIDriver},
\linkS4class{DBIConnection},
and \linkS4class{DBIResult}.
The backend provides implementation for all methods
of these base classes
that are defined but not implemented by DBI.
All methods have an ellipsis \code{...} in their formals.
}

\section{Construction of the DBIDriver object}{

The backend must support creation of an instance of its \linkS4class{DBIDriver}
subclass
with a \dfn{constructor function}.
By default, its name is the package name without the leading \sQuote{R}
(if it exists), e.g., \code{SQLite} for the \pkg{RSQLite} package.
However, backend authors may choose a different name.
The constructor must be exported, and
it must be a function
that is callable without arguments.
DBI recommends to define a constructor with an empty argument list.
}

\keyword{datasets}
