\name{rhoE}
\alias{rhoE}
\title{The limit value of the detrended cross-covariance}
\usage{
rhoE(m = 3, nu = 0, G1, G2, G12, K = NULL)
}
\arguments{
  \item{m}{an integer or integer valued vector indicating the size (or sizes) of the window for the polinomial fit. \eqn{min(m)} must be greater or equal than \eqn{nu} or else it will return an error.}
\item{nu}{a non-negative integer denoting the degree of the polinomial fit applied on the integrated series.}
  \item{G1,G2}{the autocovariance matrices for the original time series. Both are \eqn{max(m)+1} by \eqn{max(m)+1} matrices.  }
  \item{G12}{the cross-covariance matrix for the original time series. The dimension of \eqn{G12} must be \eqn{max(m)+1)} by \eqn{max(m)+1)}.}
\item{K}{optional: the matrix \eqn{K}. See the details.}
}
\value{A list containing the following elements, calculated  considering windows of size \eqn{m+1}, for each \eqn{m} supplied:
\item{EF2dfa1, EF2dfa2}{the expected values of the detrended variances.}
\item{EFdcca}{the expected value of the detrended cross-covariance.}
\item{rhoE}{the vector with the theoretical counterpart of the cross-correlation coefficient.}
}
\description{
Calculates the theoretical counterpart of the cross-correlation coefficient. This is expression (11) in Prass and Pumi (2019). For trend-stationary processes under mild assumptions, this is equivalent to the limit of the detrended cross correlation coefficient calculated with window of size \eqn{m+1} as \eqn{m} tends to infinity (see theorem 3.2 in Prass and Pumi, 2019).
}
\details{
The optional argument \eqn{K} is an \eqn{m+1} by \eqn{m+1}  matrix defined by \eqn{K = J'QJ}, where \eqn{J} is a \eqn{m+1} by \eqn{m+1} lower triangular matrix with all non-zero entries equal to one and \eqn{Q} is a \eqn{m+1} by \eqn{m+1} given by \eqn{Q = I - P} where \eqn{P} is the projection matrix into the subspace generated by degree \eqn{nu+1} polynomials and \eqn{I} is the \eqn{m+1} by \eqn{m+1}  identity matrix. \eqn{K} is equivalent to expression (18) in Prass and Pumi (2019).
If this matrix is provided and \eqn{m} is an integer, then \eqn{nu} are ignored.
}
\examples{
m = 3
K = Km(m = m, nu = 0)
G1 = G2 =  diag(m+1)
G12 = matrix(0,ncol = m+1, nrow = m+1)
rhoE(G1 = G1, G2 = G2, G12 = G12, K = K)
# same as
rhoE(m = 3, nu = 0, G1 = G1, G2 = G2, G12 = G12)
}

\references{Prass, T.S. and Pumi, G. (2019). On the behavior of the DFA and DCCA in trend-stationary
processes <arXiv:1910.10589>.}

\author{Taiane Schaedler Prass}

\seealso{\code{\link{Km}} which creates the matrix \eqn{K}, \code{\link{Jn}} which creates the matrix \eqn{J}, \code{\link{Qm}} which creates \eqn{Q} and \code{\link{Pm}} which creates \eqn{P}.}
