% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcem_cluster_mv.R
\name{dcem_cluster_mv}
\alias{dcem_cluster_mv}
\title{dcem_cluster (multivariate data): Part of DCEM package.}
\usage{
dcem_cluster_mv(data, meu, sigma, prior, num_clusters, iteration_count,
threshold, num_data)
}
\arguments{
\item{data}{A matrix: The dataset provided by the user.}

\item{meu}{(matrix): The matrix containing the initial meu(s).}

\item{sigma}{(list): A list containing the initial covariance matrices.}

\item{prior}{(vector): A vector containing the initial prior.}

\item{num_clusters}{(numeric): The number of clusters specified by the user. Default value is 2.}

\item{iteration_count}{(numeric): The number of iterations for which the algorithm should run, if the
convergence is not achieved then the algorithm stops. Default: 200.}

\item{threshold}{(numeric): A small value to check for convergence (if the estimated meu are within this
specified threshold then the algorithm stops and exit).

\strong{Note: Choosing a very small value (0.0000001) for threshold can increase the runtime substantially
and the algorithm may not converge. On the other hand, choosing a larger value (0.1)
can lead to sub-optimal clustering. Default: 0.00001}.}

\item{num_data}{(numeric): The total number of observations in the data.}
}
\value{
A list of objects. This list contains parameters associated with the
        Gaussian(s) (posterior probabilities, meu, co-variance and prior)

\enumerate{
        \item (1) Posterior Probabilities:  \strong{prob} :A matrix of
        posterior-probabilities.

        \item (2) Meu: \strong{meu}: It is a matrix of meu(s). Each row in
        the matrix corresponds to one meu.

        \item (3) Sigma: Co-variance matrices: \strong{sigma}

        \item (4) prior: \strong{prior}: A vector of prior.

        \item (5) Membership: \strong{membership}: A vector of
        cluster membership for data.
        }
}
\description{
Implements the Expectation Maximization algorithm for multivariate data. This function is called
by the dcem_train routine.
}
\references{
Using data to build a better EM: EM* for big data.

Hasan Kurban, Mark Jenne, Mehmet M. Dalkilic
(2016) <https://doi.org/10.1007/s41060-017-0062-1>.
}
\author{
Parichit Sharma \email{parishar@iu.edu}, Hasan Kurban, Mark Jenne, Mehmet Dalkilic

This work is partially supported by NCI Grant 1R01CA213466-01.
}
