// Generated by rstantools.  Do not edit by hand.

/*
    DCPO is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    DCPO is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with DCPO.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.19.1
#include <stan/model/model_header.hpp>
namespace model_dcpo_kfold_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_dcpo_kfold");
    reader.add_event(153, 151, "end", "model_dcpo_kfold");
    return reader;
}
#include <stan_meta_header.hpp>
class model_dcpo_kfold : public prob_grad {
private:
        int K;
        int T;
        int Q;
        int R;
        int N;
        std::vector<int> kk;
        std::vector<int> tt;
        std::vector<int> qq;
        std::vector<int> rr;
        std::vector<int> y_r;
        std::vector<int> n_r;
        int N_test;
        std::vector<int> kk_test;
        std::vector<int> tt_test;
        std::vector<int> qq_test;
        std::vector<int> rr_test;
        std::vector<int> n_r_test;
        std::vector<std::vector<int> > fixed_cutp;
        std::vector<vector_d> use_delta;
public:
    model_dcpo_kfold(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_dcpo_kfold(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_dcpo_kfold_namespace::model_dcpo_kfold";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 1);
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            check_greater_or_equal(function__, "T", T, 1);
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "Q", "int", context__.to_vec());
            Q = int(0);
            vals_i__ = context__.vals_i("Q");
            pos__ = 0;
            Q = vals_i__[pos__++];
            check_greater_or_equal(function__, "Q", Q, 1);
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "R", "int", context__.to_vec());
            R = int(0);
            vals_i__ = context__.vals_i("R");
            pos__ = 0;
            R = vals_i__[pos__++];
            check_greater_or_equal(function__, "R", R, 1);
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 7;
            validate_non_negative_index("kk", "N", N);
            context__.validate_dims("data initialization", "kk", "int", context__.to_vec(N));
            kk = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("kk");
            pos__ = 0;
            size_t kk_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < kk_k_0_max__; ++k_0__) {
                kk[k_0__] = vals_i__[pos__++];
            }
            size_t kk_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < kk_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "kk[i_0__]", kk[i_0__], 1);
                check_less_or_equal(function__, "kk[i_0__]", kk[i_0__], K);
            }
            current_statement_begin__ = 8;
            validate_non_negative_index("tt", "N", N);
            context__.validate_dims("data initialization", "tt", "int", context__.to_vec(N));
            tt = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("tt");
            pos__ = 0;
            size_t tt_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < tt_k_0_max__; ++k_0__) {
                tt[k_0__] = vals_i__[pos__++];
            }
            size_t tt_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < tt_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "tt[i_0__]", tt[i_0__], 1);
                check_less_or_equal(function__, "tt[i_0__]", tt[i_0__], T);
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("qq", "N", N);
            context__.validate_dims("data initialization", "qq", "int", context__.to_vec(N));
            qq = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("qq");
            pos__ = 0;
            size_t qq_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < qq_k_0_max__; ++k_0__) {
                qq[k_0__] = vals_i__[pos__++];
            }
            size_t qq_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < qq_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "qq[i_0__]", qq[i_0__], 1);
                check_less_or_equal(function__, "qq[i_0__]", qq[i_0__], Q);
            }
            current_statement_begin__ = 10;
            validate_non_negative_index("rr", "N", N);
            context__.validate_dims("data initialization", "rr", "int", context__.to_vec(N));
            rr = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("rr");
            pos__ = 0;
            size_t rr_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                rr[k_0__] = vals_i__[pos__++];
            }
            size_t rr_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < rr_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "rr[i_0__]", rr[i_0__], 1);
                check_less_or_equal(function__, "rr[i_0__]", rr[i_0__], R);
            }
            current_statement_begin__ = 11;
            validate_non_negative_index("y_r", "N", N);
            context__.validate_dims("data initialization", "y_r", "int", context__.to_vec(N));
            y_r = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("y_r");
            pos__ = 0;
            size_t y_r_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < y_r_k_0_max__; ++k_0__) {
                y_r[k_0__] = vals_i__[pos__++];
            }
            size_t y_r_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < y_r_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "y_r[i_0__]", y_r[i_0__], 1);
            }
            current_statement_begin__ = 12;
            validate_non_negative_index("n_r", "N", N);
            context__.validate_dims("data initialization", "n_r", "int", context__.to_vec(N));
            n_r = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("n_r");
            pos__ = 0;
            size_t n_r_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < n_r_k_0_max__; ++k_0__) {
                n_r[k_0__] = vals_i__[pos__++];
            }
            size_t n_r_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < n_r_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "n_r[i_0__]", n_r[i_0__], 1);
            }
            current_statement_begin__ = 13;
            context__.validate_dims("data initialization", "N_test", "int", context__.to_vec());
            N_test = int(0);
            vals_i__ = context__.vals_i("N_test");
            pos__ = 0;
            N_test = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_test", N_test, 1);
            current_statement_begin__ = 14;
            validate_non_negative_index("kk_test", "N_test", N_test);
            context__.validate_dims("data initialization", "kk_test", "int", context__.to_vec(N_test));
            kk_test = std::vector<int>(N_test, int(0));
            vals_i__ = context__.vals_i("kk_test");
            pos__ = 0;
            size_t kk_test_k_0_max__ = N_test;
            for (size_t k_0__ = 0; k_0__ < kk_test_k_0_max__; ++k_0__) {
                kk_test[k_0__] = vals_i__[pos__++];
            }
            size_t kk_test_i_0_max__ = N_test;
            for (size_t i_0__ = 0; i_0__ < kk_test_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "kk_test[i_0__]", kk_test[i_0__], 1);
                check_less_or_equal(function__, "kk_test[i_0__]", kk_test[i_0__], K);
            }
            current_statement_begin__ = 15;
            validate_non_negative_index("tt_test", "N_test", N_test);
            context__.validate_dims("data initialization", "tt_test", "int", context__.to_vec(N_test));
            tt_test = std::vector<int>(N_test, int(0));
            vals_i__ = context__.vals_i("tt_test");
            pos__ = 0;
            size_t tt_test_k_0_max__ = N_test;
            for (size_t k_0__ = 0; k_0__ < tt_test_k_0_max__; ++k_0__) {
                tt_test[k_0__] = vals_i__[pos__++];
            }
            size_t tt_test_i_0_max__ = N_test;
            for (size_t i_0__ = 0; i_0__ < tt_test_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "tt_test[i_0__]", tt_test[i_0__], 1);
                check_less_or_equal(function__, "tt_test[i_0__]", tt_test[i_0__], T);
            }
            current_statement_begin__ = 16;
            validate_non_negative_index("qq_test", "N_test", N_test);
            context__.validate_dims("data initialization", "qq_test", "int", context__.to_vec(N_test));
            qq_test = std::vector<int>(N_test, int(0));
            vals_i__ = context__.vals_i("qq_test");
            pos__ = 0;
            size_t qq_test_k_0_max__ = N_test;
            for (size_t k_0__ = 0; k_0__ < qq_test_k_0_max__; ++k_0__) {
                qq_test[k_0__] = vals_i__[pos__++];
            }
            size_t qq_test_i_0_max__ = N_test;
            for (size_t i_0__ = 0; i_0__ < qq_test_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "qq_test[i_0__]", qq_test[i_0__], 1);
                check_less_or_equal(function__, "qq_test[i_0__]", qq_test[i_0__], Q);
            }
            current_statement_begin__ = 17;
            validate_non_negative_index("rr_test", "N_test", N_test);
            context__.validate_dims("data initialization", "rr_test", "int", context__.to_vec(N_test));
            rr_test = std::vector<int>(N_test, int(0));
            vals_i__ = context__.vals_i("rr_test");
            pos__ = 0;
            size_t rr_test_k_0_max__ = N_test;
            for (size_t k_0__ = 0; k_0__ < rr_test_k_0_max__; ++k_0__) {
                rr_test[k_0__] = vals_i__[pos__++];
            }
            size_t rr_test_i_0_max__ = N_test;
            for (size_t i_0__ = 0; i_0__ < rr_test_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "rr_test[i_0__]", rr_test[i_0__], 1);
                check_less_or_equal(function__, "rr_test[i_0__]", rr_test[i_0__], R);
            }
            current_statement_begin__ = 18;
            validate_non_negative_index("n_r_test", "N_test", N_test);
            context__.validate_dims("data initialization", "n_r_test", "int", context__.to_vec(N_test));
            n_r_test = std::vector<int>(N_test, int(0));
            vals_i__ = context__.vals_i("n_r_test");
            pos__ = 0;
            size_t n_r_test_k_0_max__ = N_test;
            for (size_t k_0__ = 0; k_0__ < n_r_test_k_0_max__; ++k_0__) {
                n_r_test[k_0__] = vals_i__[pos__++];
            }
            size_t n_r_test_i_0_max__ = N_test;
            for (size_t i_0__ = 0; i_0__ < n_r_test_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "n_r_test[i_0__]", n_r_test[i_0__], 1);
            }
            current_statement_begin__ = 19;
            validate_non_negative_index("fixed_cutp", "Q", Q);
            validate_non_negative_index("fixed_cutp", "R", R);
            context__.validate_dims("data initialization", "fixed_cutp", "int", context__.to_vec(Q,R));
            fixed_cutp = std::vector<std::vector<int> >(Q, std::vector<int>(R, int(0)));
            vals_i__ = context__.vals_i("fixed_cutp");
            pos__ = 0;
            size_t fixed_cutp_k_0_max__ = Q;
            size_t fixed_cutp_k_1_max__ = R;
            for (size_t k_1__ = 0; k_1__ < fixed_cutp_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < fixed_cutp_k_0_max__; ++k_0__) {
                    fixed_cutp[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 20;
            validate_non_negative_index("use_delta", "K", K);
            validate_non_negative_index("use_delta", "Q", Q);
            context__.validate_dims("data initialization", "use_delta", "vector_d", context__.to_vec(Q,K));
            use_delta = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(Q, Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
            vals_r__ = context__.vals_r("use_delta");
            pos__ = 0;
            size_t use_delta_j_1_max__ = K;
            size_t use_delta_k_0_max__ = Q;
            for (size_t j_1__ = 0; j_1__ < use_delta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < use_delta_k_0_max__; ++k_0__) {
                    use_delta[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            size_t use_delta_i_0_max__ = Q;
            for (size_t i_0__ = 0; i_0__ < use_delta_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "use_delta[i_0__]", use_delta[i_0__], 0);
                check_less_or_equal(function__, "use_delta[i_0__]", use_delta[i_0__], 1);
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 24;
            validate_non_negative_index("alpha", "Q", Q);
            num_params_r__ += Q;
            current_statement_begin__ = 25;
            validate_non_negative_index("raw_beta", "Q", Q);
            validate_non_negative_index("raw_beta", "R", R);
            num_params_r__ += (Q * R);
            current_statement_begin__ = 26;
            validate_non_negative_index("beta_init", "Q", Q);
            num_params_r__ += Q;
            current_statement_begin__ = 27;
            validate_non_negative_index("raw_delta_N01", "K", K);
            validate_non_negative_index("raw_delta_N01", "Q", Q);
            num_params_r__ += (K * Q);
            current_statement_begin__ = 28;
            num_params_r__ += 1;
            current_statement_begin__ = 29;
            validate_non_negative_index("raw_theta_N01", "K", K);
            validate_non_negative_index("raw_theta_N01", "T", T);
            num_params_r__ += (K * T);
            current_statement_begin__ = 30;
            num_params_r__ += 1;
            current_statement_begin__ = 31;
            validate_non_negative_index("theta_init", "K", K);
            num_params_r__ += K;
            current_statement_begin__ = 32;
            validate_non_negative_index("raw_sigma_N01", "K", K);
            validate_non_negative_index("raw_sigma_N01", "T", T);
            num_params_r__ += (K * T);
            current_statement_begin__ = 33;
            num_params_r__ += 1;
            current_statement_begin__ = 34;
            validate_non_negative_index("sigma_init", "K", K);
            num_params_r__ += K;
            current_statement_begin__ = 35;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_dcpo_kfold() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 24;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        validate_non_negative_index("alpha", "Q", Q);
        context__.validate_dims("parameter initialization", "alpha", "vector_d", context__.to_vec(Q));
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha(Q);
        size_t alpha_j_1_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            alpha(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, alpha);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 25;
        if (!(context__.contains_r("raw_beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable raw_beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("raw_beta");
        pos__ = 0U;
        validate_non_negative_index("raw_beta", "Q", Q);
        validate_non_negative_index("raw_beta", "R", R);
        context__.validate_dims("parameter initialization", "raw_beta", "row_vector_d", context__.to_vec(R,Q));
        std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > raw_beta(R, Eigen::Matrix<double, 1, Eigen::Dynamic>(Q));
        size_t raw_beta_j_1_max__ = Q;
        size_t raw_beta_k_0_max__ = R;
        for (size_t j_1__ = 0; j_1__ < raw_beta_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_beta_k_0_max__; ++k_0__) {
                raw_beta[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t raw_beta_i_0_max__ = R;
        for (size_t i_0__ = 0; i_0__ < raw_beta_i_0_max__; ++i_0__) {
            try {
                writer__.row_vector_lb_unconstrain(0, raw_beta[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable raw_beta: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 26;
        if (!(context__.contains_r("beta_init")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_init missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_init");
        pos__ = 0U;
        validate_non_negative_index("beta_init", "Q", Q);
        context__.validate_dims("parameter initialization", "beta_init", "row_vector_d", context__.to_vec(Q));
        Eigen::Matrix<double, 1, Eigen::Dynamic> beta_init(Q);
        size_t beta_init_j_1_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < beta_init_j_1_max__; ++j_1__) {
            beta_init(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.row_vector_unconstrain(beta_init);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_init: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 27;
        if (!(context__.contains_r("raw_delta_N01")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable raw_delta_N01 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("raw_delta_N01");
        pos__ = 0U;
        validate_non_negative_index("raw_delta_N01", "K", K);
        validate_non_negative_index("raw_delta_N01", "Q", Q);
        context__.validate_dims("parameter initialization", "raw_delta_N01", "vector_d", context__.to_vec(Q,K));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > raw_delta_N01(Q, Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
        size_t raw_delta_N01_j_1_max__ = K;
        size_t raw_delta_N01_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < raw_delta_N01_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_delta_N01_k_0_max__; ++k_0__) {
                raw_delta_N01[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t raw_delta_N01_i_0_max__ = Q;
        for (size_t i_0__ = 0; i_0__ < raw_delta_N01_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(raw_delta_N01[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable raw_delta_N01: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 28;
        if (!(context__.contains_r("sd_delta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sd_delta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sd_delta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sd_delta", "double", context__.to_vec());
        double sd_delta(0);
        sd_delta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sd_delta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sd_delta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 29;
        if (!(context__.contains_r("raw_theta_N01")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable raw_theta_N01 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("raw_theta_N01");
        pos__ = 0U;
        validate_non_negative_index("raw_theta_N01", "K", K);
        validate_non_negative_index("raw_theta_N01", "T", T);
        context__.validate_dims("parameter initialization", "raw_theta_N01", "row_vector_d", context__.to_vec(T,K));
        std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > raw_theta_N01(T, Eigen::Matrix<double, 1, Eigen::Dynamic>(K));
        size_t raw_theta_N01_j_1_max__ = K;
        size_t raw_theta_N01_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < raw_theta_N01_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_theta_N01_k_0_max__; ++k_0__) {
                raw_theta_N01[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t raw_theta_N01_i_0_max__ = T;
        for (size_t i_0__ = 0; i_0__ < raw_theta_N01_i_0_max__; ++i_0__) {
            try {
                writer__.row_vector_unconstrain(raw_theta_N01[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable raw_theta_N01: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 30;
        if (!(context__.contains_r("sd_theta_evolve")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sd_theta_evolve missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sd_theta_evolve");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sd_theta_evolve", "double", context__.to_vec());
        double sd_theta_evolve(0);
        sd_theta_evolve = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sd_theta_evolve);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sd_theta_evolve: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 31;
        if (!(context__.contains_r("theta_init")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta_init missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta_init");
        pos__ = 0U;
        validate_non_negative_index("theta_init", "K", K);
        context__.validate_dims("parameter initialization", "theta_init", "row_vector_d", context__.to_vec(K));
        Eigen::Matrix<double, 1, Eigen::Dynamic> theta_init(K);
        size_t theta_init_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < theta_init_j_1_max__; ++j_1__) {
            theta_init(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.row_vector_unconstrain(theta_init);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta_init: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 32;
        if (!(context__.contains_r("raw_sigma_N01")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable raw_sigma_N01 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("raw_sigma_N01");
        pos__ = 0U;
        validate_non_negative_index("raw_sigma_N01", "K", K);
        validate_non_negative_index("raw_sigma_N01", "T", T);
        context__.validate_dims("parameter initialization", "raw_sigma_N01", "row_vector_d", context__.to_vec(T,K));
        std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > raw_sigma_N01(T, Eigen::Matrix<double, 1, Eigen::Dynamic>(K));
        size_t raw_sigma_N01_j_1_max__ = K;
        size_t raw_sigma_N01_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < raw_sigma_N01_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_sigma_N01_k_0_max__; ++k_0__) {
                raw_sigma_N01[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t raw_sigma_N01_i_0_max__ = T;
        for (size_t i_0__ = 0; i_0__ < raw_sigma_N01_i_0_max__; ++i_0__) {
            try {
                writer__.row_vector_unconstrain(raw_sigma_N01[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable raw_sigma_N01: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 33;
        if (!(context__.contains_r("sd_sigma_evolve")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sd_sigma_evolve missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sd_sigma_evolve");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sd_sigma_evolve", "double", context__.to_vec());
        double sd_sigma_evolve(0);
        sd_sigma_evolve = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sd_sigma_evolve);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sd_sigma_evolve: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 34;
        if (!(context__.contains_r("sigma_init")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_init missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_init");
        pos__ = 0U;
        validate_non_negative_index("sigma_init", "K", K);
        context__.validate_dims("parameter initialization", "sigma_init", "row_vector_d", context__.to_vec(K));
        Eigen::Matrix<double, 1, Eigen::Dynamic> sigma_init(K);
        size_t sigma_init_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < sigma_init_j_1_max__; ++j_1__) {
            sigma_init(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.row_vector_unconstrain(sigma_init);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_init: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 35;
        if (!(context__.contains_r("phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "phi", "double", context__.to_vec());
        double phi(0);
        phi = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, phi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 24;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.vector_lb_constrain(0, Q, lp__);
            else
                alpha = in__.vector_lb_constrain(0, Q);
            current_statement_begin__ = 25;
            std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> > raw_beta;
            size_t raw_beta_d_0_max__ = R;
            raw_beta.reserve(raw_beta_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < raw_beta_d_0_max__; ++d_0__) {
                if (jacobian__)
                    raw_beta.push_back(in__.row_vector_lb_constrain(0, Q, lp__));
                else
                    raw_beta.push_back(in__.row_vector_lb_constrain(0, Q));
            }
            current_statement_begin__ = 26;
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> beta_init;
            (void) beta_init;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_init = in__.row_vector_constrain(Q, lp__);
            else
                beta_init = in__.row_vector_constrain(Q);
            current_statement_begin__ = 27;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > raw_delta_N01;
            size_t raw_delta_N01_d_0_max__ = Q;
            raw_delta_N01.reserve(raw_delta_N01_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < raw_delta_N01_d_0_max__; ++d_0__) {
                if (jacobian__)
                    raw_delta_N01.push_back(in__.vector_constrain(K, lp__));
                else
                    raw_delta_N01.push_back(in__.vector_constrain(K));
            }
            current_statement_begin__ = 28;
            local_scalar_t__ sd_delta;
            (void) sd_delta;  // dummy to suppress unused var warning
            if (jacobian__)
                sd_delta = in__.scalar_lb_constrain(0, lp__);
            else
                sd_delta = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 29;
            std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> > raw_theta_N01;
            size_t raw_theta_N01_d_0_max__ = T;
            raw_theta_N01.reserve(raw_theta_N01_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < raw_theta_N01_d_0_max__; ++d_0__) {
                if (jacobian__)
                    raw_theta_N01.push_back(in__.row_vector_constrain(K, lp__));
                else
                    raw_theta_N01.push_back(in__.row_vector_constrain(K));
            }
            current_statement_begin__ = 30;
            local_scalar_t__ sd_theta_evolve;
            (void) sd_theta_evolve;  // dummy to suppress unused var warning
            if (jacobian__)
                sd_theta_evolve = in__.scalar_lb_constrain(0, lp__);
            else
                sd_theta_evolve = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 31;
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> theta_init;
            (void) theta_init;  // dummy to suppress unused var warning
            if (jacobian__)
                theta_init = in__.row_vector_constrain(K, lp__);
            else
                theta_init = in__.row_vector_constrain(K);
            current_statement_begin__ = 32;
            std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> > raw_sigma_N01;
            size_t raw_sigma_N01_d_0_max__ = T;
            raw_sigma_N01.reserve(raw_sigma_N01_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < raw_sigma_N01_d_0_max__; ++d_0__) {
                if (jacobian__)
                    raw_sigma_N01.push_back(in__.row_vector_constrain(K, lp__));
                else
                    raw_sigma_N01.push_back(in__.row_vector_constrain(K));
            }
            current_statement_begin__ = 33;
            local_scalar_t__ sd_sigma_evolve;
            (void) sd_sigma_evolve;  // dummy to suppress unused var warning
            if (jacobian__)
                sd_sigma_evolve = in__.scalar_lb_constrain(0, lp__);
            else
                sd_sigma_evolve = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 34;
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> sigma_init;
            (void) sigma_init;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_init = in__.row_vector_constrain(K, lp__);
            else
                sigma_init = in__.row_vector_constrain(K);
            current_statement_begin__ = 35;
            local_scalar_t__ phi;
            (void) phi;  // dummy to suppress unused var warning
            if (jacobian__)
                phi = in__.scalar_lb_constrain(0, lp__);
            else
                phi = in__.scalar_lb_constrain(0);
            // transformed parameters
            current_statement_begin__ = 39;
            validate_non_negative_index("beta", "Q", Q);
            validate_non_negative_index("beta", "R", R);
            std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> > beta(R, Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic>(Q));
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 40;
            validate_non_negative_index("beta_rr_qq", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_rr_qq(N);
            stan::math::initialize(beta_rr_qq, DUMMY_VAR__);
            stan::math::fill(beta_rr_qq, DUMMY_VAR__);
            current_statement_begin__ = 41;
            validate_non_negative_index("beta_rr_qq_test", "N_test", N_test);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_rr_qq_test(N_test);
            stan::math::initialize(beta_rr_qq_test, DUMMY_VAR__);
            stan::math::fill(beta_rr_qq_test, DUMMY_VAR__);
            current_statement_begin__ = 42;
            validate_non_negative_index("raw_delta", "K", K);
            validate_non_negative_index("raw_delta", "Q", Q);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > raw_delta(Q, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(K));
            stan::math::initialize(raw_delta, DUMMY_VAR__);
            stan::math::fill(raw_delta, DUMMY_VAR__);
            current_statement_begin__ = 43;
            validate_non_negative_index("mean_raw_delta", "Q", Q);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mean_raw_delta(Q);
            stan::math::initialize(mean_raw_delta, DUMMY_VAR__);
            stan::math::fill(mean_raw_delta, DUMMY_VAR__);
            current_statement_begin__ = 44;
            validate_non_negative_index("delta", "K", K);
            validate_non_negative_index("delta", "Q", Q);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > delta(Q, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(K));
            stan::math::initialize(delta, DUMMY_VAR__);
            stan::math::fill(delta, DUMMY_VAR__);
            current_statement_begin__ = 45;
            validate_non_negative_index("delta_qq_kk", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delta_qq_kk(N);
            stan::math::initialize(delta_qq_kk, DUMMY_VAR__);
            stan::math::fill(delta_qq_kk, DUMMY_VAR__);
            current_statement_begin__ = 46;
            validate_non_negative_index("delta_qq_kk_test", "N_test", N_test);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delta_qq_kk_test(N_test);
            stan::math::initialize(delta_qq_kk_test, DUMMY_VAR__);
            stan::math::fill(delta_qq_kk_test, DUMMY_VAR__);
            current_statement_begin__ = 47;
            validate_non_negative_index("raw_theta", "K", K);
            validate_non_negative_index("raw_theta", "T", T);
            std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> > raw_theta(T, Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic>(K));
            stan::math::initialize(raw_theta, DUMMY_VAR__);
            stan::math::fill(raw_theta, DUMMY_VAR__);
            current_statement_begin__ = 48;
            validate_non_negative_index("theta", "K", K);
            validate_non_negative_index("theta", "T", T);
            std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> > theta(T, Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic>(K));
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 49;
            validate_non_negative_index("raw_theta_tt_kk", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> raw_theta_tt_kk(N);
            stan::math::initialize(raw_theta_tt_kk, DUMMY_VAR__);
            stan::math::fill(raw_theta_tt_kk, DUMMY_VAR__);
            current_statement_begin__ = 50;
            validate_non_negative_index("raw_theta_tt_kk_test", "N_test", N_test);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> raw_theta_tt_kk_test(N_test);
            stan::math::initialize(raw_theta_tt_kk_test, DUMMY_VAR__);
            stan::math::fill(raw_theta_tt_kk_test, DUMMY_VAR__);
            current_statement_begin__ = 51;
            validate_non_negative_index("raw_sigma", "K", K);
            validate_non_negative_index("raw_sigma", "T", T);
            std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> > raw_sigma(T, Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic>(K));
            stan::math::initialize(raw_sigma, DUMMY_VAR__);
            stan::math::fill(raw_sigma, DUMMY_VAR__);
            current_statement_begin__ = 52;
            validate_non_negative_index("sigma", "K", K);
            validate_non_negative_index("sigma", "T", T);
            std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> > sigma(T, Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic>(K));
            stan::math::initialize(sigma, DUMMY_VAR__);
            stan::math::fill(sigma, DUMMY_VAR__);
            current_statement_begin__ = 53;
            validate_non_negative_index("sigma_tt_kk", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sigma_tt_kk(N);
            stan::math::initialize(sigma_tt_kk, DUMMY_VAR__);
            stan::math::fill(sigma_tt_kk, DUMMY_VAR__);
            current_statement_begin__ = 54;
            validate_non_negative_index("sigma_tt_kk_test", "N_test", N_test);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sigma_tt_kk_test(N_test);
            stan::math::initialize(sigma_tt_kk_test, DUMMY_VAR__);
            stan::math::fill(sigma_tt_kk_test, DUMMY_VAR__);
            current_statement_begin__ = 55;
            validate_non_negative_index("eta", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta(N);
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            current_statement_begin__ = 56;
            validate_non_negative_index("eta_test", "N_test", N_test);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_test(N_test);
            stan::math::initialize(eta_test, DUMMY_VAR__);
            stan::math::fill(eta_test, DUMMY_VAR__);
            current_statement_begin__ = 57;
            validate_non_negative_index("a", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> a(N);
            stan::math::initialize(a, DUMMY_VAR__);
            stan::math::fill(a, DUMMY_VAR__);
            current_statement_begin__ = 58;
            validate_non_negative_index("a_test", "N_test", N_test);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> a_test(N_test);
            stan::math::initialize(a_test, DUMMY_VAR__);
            stan::math::fill(a_test, DUMMY_VAR__);
            current_statement_begin__ = 59;
            validate_non_negative_index("b", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b(N);
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            current_statement_begin__ = 60;
            validate_non_negative_index("b_test", "N_test", N_test);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b_test(N_test);
            stan::math::initialize(b_test, DUMMY_VAR__);
            stan::math::fill(b_test, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 63;
            for (int q = 1; q <= Q; ++q) {
                current_statement_begin__ = 65;
                for (int r = 1; r <= R; ++r) {
                    current_statement_begin__ = 66;
                    if (as_bool(logical_eq(get_base1(get_base1(fixed_cutp, q, "fixed_cutp", 1), r, "fixed_cutp", 2), 1))) {
                        current_statement_begin__ = 67;
                        stan::model::assign(beta, 
                                    stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(q), stan::model::nil_index_list())), 
                                    .5, 
                                    "assigning variable beta");
                    } else {
                        current_statement_begin__ = 69;
                        if (as_bool(logical_eq(r, 1))) {
                            current_statement_begin__ = 70;
                            stan::model::assign(beta, 
                                        stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(q), stan::model::nil_index_list())), 
                                        get_base1(beta_init, q, "beta_init", 1), 
                                        "assigning variable beta");
                        } else {
                            current_statement_begin__ = 72;
                            stan::model::assign(beta, 
                                        stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(q), stan::model::nil_index_list())), 
                                        (get_base1(get_base1(beta, (r - 1), "beta", 1), q, "beta", 2) + get_base1(get_base1(raw_beta, r, "raw_beta", 1), q, "raw_beta", 2)), 
                                        "assigning variable beta");
                        }
                    }
                }
                current_statement_begin__ = 77;
                stan::model::assign(raw_delta, 
                            stan::model::cons_list(stan::model::index_uni(q), stan::model::nil_index_list()), 
                            elt_multiply(multiply(sd_delta, get_base1(raw_delta_N01, q, "raw_delta_N01", 1)), get_base1(use_delta, q, "use_delta", 1)), 
                            "assigning variable raw_delta");
                current_statement_begin__ = 78;
                stan::model::assign(mean_raw_delta, 
                            stan::model::cons_list(stan::model::index_uni(q), stan::model::nil_index_list()), 
                            mean(get_base1(raw_delta, q, "raw_delta", 1)), 
                            "assigning variable mean_raw_delta");
                current_statement_begin__ = 79;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 80;
                    stan::model::assign(delta, 
                                stan::model::cons_list(stan::model::index_uni(q), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                (get_base1(get_base1(raw_delta, q, "raw_delta", 1), k, "raw_delta", 2) - get_base1(mean_raw_delta, q, "mean_raw_delta", 1)), 
                                "assigning variable delta");
                }
            }
            current_statement_begin__ = 85;
            stan::model::assign(raw_theta, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        theta_init, 
                        "assigning variable raw_theta");
            current_statement_begin__ = 86;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        Phi_approx(subtract(theta_init, .5)), 
                        "assigning variable theta");
            current_statement_begin__ = 87;
            stan::model::assign(raw_sigma, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        sigma_init, 
                        "assigning variable raw_sigma");
            current_statement_begin__ = 88;
            stan::model::assign(sigma, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        multiply(Phi_approx(sigma_init), .25), 
                        "assigning variable sigma");
            current_statement_begin__ = 91;
            for (int t = 2; t <= T; ++t) {
                current_statement_begin__ = 92;
                stan::model::assign(raw_theta, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            add(get_base1(raw_theta, (t - 1), "raw_theta", 1), multiply(sd_theta_evolve, get_base1(raw_theta_N01, t, "raw_theta_N01", 1))), 
                            "assigning variable raw_theta");
                current_statement_begin__ = 93;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            Phi_approx(subtract(get_base1(raw_theta, t, "raw_theta", 1), .5)), 
                            "assigning variable theta");
                current_statement_begin__ = 94;
                stan::model::assign(raw_sigma, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            add(get_base1(raw_sigma, (t - 1), "raw_sigma", 1), multiply(sd_sigma_evolve, get_base1(raw_sigma_N01, t, "raw_sigma_N01", 1))), 
                            "assigning variable raw_sigma");
                current_statement_begin__ = 95;
                stan::model::assign(sigma, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            multiply(Phi_approx(get_base1(raw_sigma, t, "raw_sigma", 1)), .25), 
                            "assigning variable sigma");
            }
            current_statement_begin__ = 98;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 99;
                stan::model::assign(beta_rr_qq, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(beta, get_base1(rr, n, "rr", 1), "beta", 1), get_base1(qq, n, "qq", 1), "beta", 2), 
                            "assigning variable beta_rr_qq");
                current_statement_begin__ = 100;
                stan::model::assign(delta_qq_kk, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(delta, get_base1(qq, n, "qq", 1), "delta", 1), get_base1(kk, n, "kk", 1), "delta", 2), 
                            "assigning variable delta_qq_kk");
                current_statement_begin__ = 101;
                stan::model::assign(raw_theta_tt_kk, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(raw_theta, get_base1(tt, n, "tt", 1), "raw_theta", 1), get_base1(kk, n, "kk", 1), "raw_theta", 2), 
                            "assigning variable raw_theta_tt_kk");
                current_statement_begin__ = 102;
                stan::model::assign(sigma_tt_kk, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(sigma, get_base1(tt, n, "tt", 1), "sigma", 1), get_base1(kk, n, "kk", 1), "sigma", 2), 
                            "assigning variable sigma_tt_kk");
            }
            current_statement_begin__ = 105;
            for (int n = 1; n <= N_test; ++n) {
                current_statement_begin__ = 106;
                stan::model::assign(beta_rr_qq_test, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(beta, get_base1(rr_test, n, "rr_test", 1), "beta", 1), get_base1(qq_test, n, "qq_test", 1), "beta", 2), 
                            "assigning variable beta_rr_qq_test");
                current_statement_begin__ = 107;
                stan::model::assign(delta_qq_kk_test, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(delta, get_base1(qq_test, n, "qq_test", 1), "delta", 1), get_base1(kk_test, n, "kk_test", 1), "delta", 2), 
                            "assigning variable delta_qq_kk_test");
                current_statement_begin__ = 108;
                stan::model::assign(raw_theta_tt_kk_test, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(raw_theta, get_base1(tt_test, n, "tt_test", 1), "raw_theta", 1), get_base1(kk_test, n, "kk_test", 1), "raw_theta", 2), 
                            "assigning variable raw_theta_tt_kk_test");
                current_statement_begin__ = 109;
                stan::model::assign(sigma_tt_kk_test, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(sigma, get_base1(tt_test, n, "tt_test", 1), "sigma", 1), get_base1(kk_test, n, "kk_test", 1), "sigma", 2), 
                            "assigning variable sigma_tt_kk_test");
            }
            current_statement_begin__ = 113;
            stan::math::assign(eta, inv_logit(elt_divide(subtract(raw_theta_tt_kk, add(beta_rr_qq, delta_qq_kk)), stan::math::sqrt(add(sigma_tt_kk, square(stan::model::rvalue(alpha, stan::model::cons_list(stan::model::index_multi(qq), stan::model::nil_index_list()), "alpha")))))));
            current_statement_begin__ = 114;
            stan::math::assign(a, multiply(phi, eta));
            current_statement_begin__ = 115;
            stan::math::assign(b, multiply(phi, subtract(1, eta)));
            current_statement_begin__ = 118;
            stan::math::assign(eta_test, inv_logit(elt_divide(subtract(raw_theta_tt_kk_test, add(beta_rr_qq_test, delta_qq_kk_test)), stan::math::sqrt(add(sigma_tt_kk_test, square(stan::model::rvalue(alpha, stan::model::cons_list(stan::model::index_multi(qq_test), stan::model::nil_index_list()), "alpha")))))));
            current_statement_begin__ = 119;
            stan::math::assign(a_test, multiply(phi, eta_test));
            current_statement_begin__ = 120;
            stan::math::assign(b_test, multiply(phi, subtract(1, eta_test)));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 39;
            size_t beta_k_0_max__ = R;
            size_t beta_j_1_max__ = Q;
            for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(beta[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: beta" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 40;
            size_t beta_rr_qq_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < beta_rr_qq_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(beta_rr_qq(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_rr_qq" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta_rr_qq: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 41;
            size_t beta_rr_qq_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < beta_rr_qq_test_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(beta_rr_qq_test(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_rr_qq_test" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta_rr_qq_test: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 42;
            size_t raw_delta_k_0_max__ = Q;
            size_t raw_delta_j_1_max__ = K;
            for (size_t k_0__ = 0; k_0__ < raw_delta_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < raw_delta_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(raw_delta[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: raw_delta" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable raw_delta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 43;
            size_t mean_raw_delta_j_1_max__ = Q;
            for (size_t j_1__ = 0; j_1__ < mean_raw_delta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mean_raw_delta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mean_raw_delta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mean_raw_delta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 44;
            size_t delta_k_0_max__ = Q;
            size_t delta_j_1_max__ = K;
            for (size_t k_0__ = 0; k_0__ < delta_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(delta[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: delta" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable delta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 45;
            size_t delta_qq_kk_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < delta_qq_kk_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(delta_qq_kk(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: delta_qq_kk" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable delta_qq_kk: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 46;
            size_t delta_qq_kk_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < delta_qq_kk_test_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(delta_qq_kk_test(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: delta_qq_kk_test" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable delta_qq_kk_test: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 47;
            size_t raw_theta_k_0_max__ = T;
            size_t raw_theta_j_1_max__ = K;
            for (size_t k_0__ = 0; k_0__ < raw_theta_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < raw_theta_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(raw_theta[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: raw_theta" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable raw_theta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 48;
            size_t theta_k_0_max__ = T;
            size_t theta_j_1_max__ = K;
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(theta[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: theta" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 49;
            size_t raw_theta_tt_kk_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < raw_theta_tt_kk_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(raw_theta_tt_kk(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: raw_theta_tt_kk" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable raw_theta_tt_kk: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 50;
            size_t raw_theta_tt_kk_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < raw_theta_tt_kk_test_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(raw_theta_tt_kk_test(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: raw_theta_tt_kk_test" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable raw_theta_tt_kk_test: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 51;
            size_t raw_sigma_k_0_max__ = T;
            size_t raw_sigma_j_1_max__ = K;
            for (size_t k_0__ = 0; k_0__ < raw_sigma_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < raw_sigma_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(raw_sigma[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: raw_sigma" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable raw_sigma: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 52;
            size_t sigma_k_0_max__ = T;
            size_t sigma_j_1_max__ = K;
            for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(sigma[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: sigma" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sigma: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 53;
            size_t sigma_tt_kk_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < sigma_tt_kk_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(sigma_tt_kk(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sigma_tt_kk" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sigma_tt_kk: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 54;
            size_t sigma_tt_kk_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < sigma_tt_kk_test_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(sigma_tt_kk_test(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sigma_tt_kk_test" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sigma_tt_kk_test: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 55;
            size_t eta_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(eta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: eta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "eta", eta, 0);
            check_less_or_equal(function__, "eta", eta, 1);
            current_statement_begin__ = 56;
            size_t eta_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < eta_test_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(eta_test(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: eta_test" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta_test: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "eta_test", eta_test, 0);
            check_less_or_equal(function__, "eta_test", eta_test, 1);
            current_statement_begin__ = 57;
            size_t a_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(a(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: a" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable a: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "a", a, 0);
            current_statement_begin__ = 58;
            size_t a_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < a_test_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(a_test(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: a_test" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable a_test: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "a_test", a_test, 0);
            current_statement_begin__ = 59;
            size_t b_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(b(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "b", b, 0);
            current_statement_begin__ = 60;
            size_t b_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < b_test_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(b_test(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b_test" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b_test: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "b_test", b_test, 0);
            // model body
            current_statement_begin__ = 124;
            lp_accum__.add(beta_binomial_log<propto__>(y_r, n_r, a, b));
            current_statement_begin__ = 125;
            lp_accum__.add(gamma_log<propto__>(phi, 4, 0.1));
            current_statement_begin__ = 127;
            lp_accum__.add(std_normal_log<propto__>(alpha));
            current_statement_begin__ = 128;
            lp_accum__.add(std_normal_log<propto__>(beta_init));
            current_statement_begin__ = 129;
            for (int r = 1; r <= R; ++r) {
                current_statement_begin__ = 130;
                lp_accum__.add(std_normal_log<propto__>(get_base1(raw_beta, r, "raw_beta", 1)));
            }
            current_statement_begin__ = 132;
            for (int q = 1; q <= Q; ++q) {
                current_statement_begin__ = 133;
                lp_accum__.add(std_normal_log<propto__>(get_base1(raw_delta_N01, q, "raw_delta_N01", 1)));
            }
            current_statement_begin__ = 135;
            lp_accum__.add(std_normal_log<propto__>(sd_delta));
            current_statement_begin__ = 136;
            lp_accum__.add(std_normal_log<propto__>(theta_init));
            current_statement_begin__ = 137;
            lp_accum__.add(std_normal_log<propto__>(sigma_init));
            current_statement_begin__ = 138;
            for (int t = 1; t <= T; ++t) {
                current_statement_begin__ = 139;
                lp_accum__.add(std_normal_log<propto__>(get_base1(raw_theta_N01, t, "raw_theta_N01", 1)));
                current_statement_begin__ = 140;
                lp_accum__.add(std_normal_log<propto__>(get_base1(raw_sigma_N01, t, "raw_sigma_N01", 1)));
            }
            current_statement_begin__ = 142;
            lp_accum__.add(std_normal_log<propto__>(sd_theta_evolve));
            current_statement_begin__ = 143;
            lp_accum__.add(std_normal_log<propto__>(sd_sigma_evolve));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("raw_beta");
        names__.push_back("beta_init");
        names__.push_back("raw_delta_N01");
        names__.push_back("sd_delta");
        names__.push_back("raw_theta_N01");
        names__.push_back("sd_theta_evolve");
        names__.push_back("theta_init");
        names__.push_back("raw_sigma_N01");
        names__.push_back("sd_sigma_evolve");
        names__.push_back("sigma_init");
        names__.push_back("phi");
        names__.push_back("beta");
        names__.push_back("beta_rr_qq");
        names__.push_back("beta_rr_qq_test");
        names__.push_back("raw_delta");
        names__.push_back("mean_raw_delta");
        names__.push_back("delta");
        names__.push_back("delta_qq_kk");
        names__.push_back("delta_qq_kk_test");
        names__.push_back("raw_theta");
        names__.push_back("theta");
        names__.push_back("raw_theta_tt_kk");
        names__.push_back("raw_theta_tt_kk_test");
        names__.push_back("raw_sigma");
        names__.push_back("sigma");
        names__.push_back("sigma_tt_kk");
        names__.push_back("sigma_tt_kk_test");
        names__.push_back("eta");
        names__.push_back("eta_test");
        names__.push_back("a");
        names__.push_back("a_test");
        names__.push_back("b");
        names__.push_back("b_test");
        names__.push_back("y_r_test");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(Q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(R);
        dims__.push_back(Q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(R);
        dims__.push_back(Q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_test);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_test);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_test);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_test);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_test);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_test);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_test);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_test);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_dcpo_kfold_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha = in__.vector_lb_constrain(0, Q);
        size_t alpha_j_1_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            vars__.push_back(alpha(j_1__));
        }
        std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > raw_beta;
        size_t raw_beta_d_0_max__ = R;
        raw_beta.reserve(raw_beta_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < raw_beta_d_0_max__; ++d_0__) {
            raw_beta.push_back(in__.row_vector_lb_constrain(0, Q));
        }
        size_t raw_beta_j_1_max__ = Q;
        size_t raw_beta_k_0_max__ = R;
        for (size_t j_1__ = 0; j_1__ < raw_beta_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_beta_k_0_max__; ++k_0__) {
                vars__.push_back(raw_beta[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, 1, Eigen::Dynamic> beta_init = in__.row_vector_constrain(Q);
        size_t beta_init_j_1_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < beta_init_j_1_max__; ++j_1__) {
            vars__.push_back(beta_init(j_1__));
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > raw_delta_N01;
        size_t raw_delta_N01_d_0_max__ = Q;
        raw_delta_N01.reserve(raw_delta_N01_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < raw_delta_N01_d_0_max__; ++d_0__) {
            raw_delta_N01.push_back(in__.vector_constrain(K));
        }
        size_t raw_delta_N01_j_1_max__ = K;
        size_t raw_delta_N01_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < raw_delta_N01_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_delta_N01_k_0_max__; ++k_0__) {
                vars__.push_back(raw_delta_N01[k_0__](j_1__));
            }
        }
        double sd_delta = in__.scalar_lb_constrain(0);
        vars__.push_back(sd_delta);
        std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > raw_theta_N01;
        size_t raw_theta_N01_d_0_max__ = T;
        raw_theta_N01.reserve(raw_theta_N01_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < raw_theta_N01_d_0_max__; ++d_0__) {
            raw_theta_N01.push_back(in__.row_vector_constrain(K));
        }
        size_t raw_theta_N01_j_1_max__ = K;
        size_t raw_theta_N01_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < raw_theta_N01_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_theta_N01_k_0_max__; ++k_0__) {
                vars__.push_back(raw_theta_N01[k_0__](j_1__));
            }
        }
        double sd_theta_evolve = in__.scalar_lb_constrain(0);
        vars__.push_back(sd_theta_evolve);
        Eigen::Matrix<double, 1, Eigen::Dynamic> theta_init = in__.row_vector_constrain(K);
        size_t theta_init_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < theta_init_j_1_max__; ++j_1__) {
            vars__.push_back(theta_init(j_1__));
        }
        std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > raw_sigma_N01;
        size_t raw_sigma_N01_d_0_max__ = T;
        raw_sigma_N01.reserve(raw_sigma_N01_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < raw_sigma_N01_d_0_max__; ++d_0__) {
            raw_sigma_N01.push_back(in__.row_vector_constrain(K));
        }
        size_t raw_sigma_N01_j_1_max__ = K;
        size_t raw_sigma_N01_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < raw_sigma_N01_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_sigma_N01_k_0_max__; ++k_0__) {
                vars__.push_back(raw_sigma_N01[k_0__](j_1__));
            }
        }
        double sd_sigma_evolve = in__.scalar_lb_constrain(0);
        vars__.push_back(sd_sigma_evolve);
        Eigen::Matrix<double, 1, Eigen::Dynamic> sigma_init = in__.row_vector_constrain(K);
        size_t sigma_init_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < sigma_init_j_1_max__; ++j_1__) {
            vars__.push_back(sigma_init(j_1__));
        }
        double phi = in__.scalar_lb_constrain(0);
        vars__.push_back(phi);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 39;
            validate_non_negative_index("beta", "Q", Q);
            validate_non_negative_index("beta", "R", R);
            std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > beta(R, Eigen::Matrix<double, 1, Eigen::Dynamic>(Q));
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 40;
            validate_non_negative_index("beta_rr_qq", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> beta_rr_qq(N);
            stan::math::initialize(beta_rr_qq, DUMMY_VAR__);
            stan::math::fill(beta_rr_qq, DUMMY_VAR__);
            current_statement_begin__ = 41;
            validate_non_negative_index("beta_rr_qq_test", "N_test", N_test);
            Eigen::Matrix<double, Eigen::Dynamic, 1> beta_rr_qq_test(N_test);
            stan::math::initialize(beta_rr_qq_test, DUMMY_VAR__);
            stan::math::fill(beta_rr_qq_test, DUMMY_VAR__);
            current_statement_begin__ = 42;
            validate_non_negative_index("raw_delta", "K", K);
            validate_non_negative_index("raw_delta", "Q", Q);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > raw_delta(Q, Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
            stan::math::initialize(raw_delta, DUMMY_VAR__);
            stan::math::fill(raw_delta, DUMMY_VAR__);
            current_statement_begin__ = 43;
            validate_non_negative_index("mean_raw_delta", "Q", Q);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mean_raw_delta(Q);
            stan::math::initialize(mean_raw_delta, DUMMY_VAR__);
            stan::math::fill(mean_raw_delta, DUMMY_VAR__);
            current_statement_begin__ = 44;
            validate_non_negative_index("delta", "K", K);
            validate_non_negative_index("delta", "Q", Q);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > delta(Q, Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
            stan::math::initialize(delta, DUMMY_VAR__);
            stan::math::fill(delta, DUMMY_VAR__);
            current_statement_begin__ = 45;
            validate_non_negative_index("delta_qq_kk", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> delta_qq_kk(N);
            stan::math::initialize(delta_qq_kk, DUMMY_VAR__);
            stan::math::fill(delta_qq_kk, DUMMY_VAR__);
            current_statement_begin__ = 46;
            validate_non_negative_index("delta_qq_kk_test", "N_test", N_test);
            Eigen::Matrix<double, Eigen::Dynamic, 1> delta_qq_kk_test(N_test);
            stan::math::initialize(delta_qq_kk_test, DUMMY_VAR__);
            stan::math::fill(delta_qq_kk_test, DUMMY_VAR__);
            current_statement_begin__ = 47;
            validate_non_negative_index("raw_theta", "K", K);
            validate_non_negative_index("raw_theta", "T", T);
            std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > raw_theta(T, Eigen::Matrix<double, 1, Eigen::Dynamic>(K));
            stan::math::initialize(raw_theta, DUMMY_VAR__);
            stan::math::fill(raw_theta, DUMMY_VAR__);
            current_statement_begin__ = 48;
            validate_non_negative_index("theta", "K", K);
            validate_non_negative_index("theta", "T", T);
            std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > theta(T, Eigen::Matrix<double, 1, Eigen::Dynamic>(K));
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 49;
            validate_non_negative_index("raw_theta_tt_kk", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> raw_theta_tt_kk(N);
            stan::math::initialize(raw_theta_tt_kk, DUMMY_VAR__);
            stan::math::fill(raw_theta_tt_kk, DUMMY_VAR__);
            current_statement_begin__ = 50;
            validate_non_negative_index("raw_theta_tt_kk_test", "N_test", N_test);
            Eigen::Matrix<double, Eigen::Dynamic, 1> raw_theta_tt_kk_test(N_test);
            stan::math::initialize(raw_theta_tt_kk_test, DUMMY_VAR__);
            stan::math::fill(raw_theta_tt_kk_test, DUMMY_VAR__);
            current_statement_begin__ = 51;
            validate_non_negative_index("raw_sigma", "K", K);
            validate_non_negative_index("raw_sigma", "T", T);
            std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > raw_sigma(T, Eigen::Matrix<double, 1, Eigen::Dynamic>(K));
            stan::math::initialize(raw_sigma, DUMMY_VAR__);
            stan::math::fill(raw_sigma, DUMMY_VAR__);
            current_statement_begin__ = 52;
            validate_non_negative_index("sigma", "K", K);
            validate_non_negative_index("sigma", "T", T);
            std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > sigma(T, Eigen::Matrix<double, 1, Eigen::Dynamic>(K));
            stan::math::initialize(sigma, DUMMY_VAR__);
            stan::math::fill(sigma, DUMMY_VAR__);
            current_statement_begin__ = 53;
            validate_non_negative_index("sigma_tt_kk", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_tt_kk(N);
            stan::math::initialize(sigma_tt_kk, DUMMY_VAR__);
            stan::math::fill(sigma_tt_kk, DUMMY_VAR__);
            current_statement_begin__ = 54;
            validate_non_negative_index("sigma_tt_kk_test", "N_test", N_test);
            Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_tt_kk_test(N_test);
            stan::math::initialize(sigma_tt_kk_test, DUMMY_VAR__);
            stan::math::fill(sigma_tt_kk_test, DUMMY_VAR__);
            current_statement_begin__ = 55;
            validate_non_negative_index("eta", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> eta(N);
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            current_statement_begin__ = 56;
            validate_non_negative_index("eta_test", "N_test", N_test);
            Eigen::Matrix<double, Eigen::Dynamic, 1> eta_test(N_test);
            stan::math::initialize(eta_test, DUMMY_VAR__);
            stan::math::fill(eta_test, DUMMY_VAR__);
            current_statement_begin__ = 57;
            validate_non_negative_index("a", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> a(N);
            stan::math::initialize(a, DUMMY_VAR__);
            stan::math::fill(a, DUMMY_VAR__);
            current_statement_begin__ = 58;
            validate_non_negative_index("a_test", "N_test", N_test);
            Eigen::Matrix<double, Eigen::Dynamic, 1> a_test(N_test);
            stan::math::initialize(a_test, DUMMY_VAR__);
            stan::math::fill(a_test, DUMMY_VAR__);
            current_statement_begin__ = 59;
            validate_non_negative_index("b", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> b(N);
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            current_statement_begin__ = 60;
            validate_non_negative_index("b_test", "N_test", N_test);
            Eigen::Matrix<double, Eigen::Dynamic, 1> b_test(N_test);
            stan::math::initialize(b_test, DUMMY_VAR__);
            stan::math::fill(b_test, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 63;
            for (int q = 1; q <= Q; ++q) {
                current_statement_begin__ = 65;
                for (int r = 1; r <= R; ++r) {
                    current_statement_begin__ = 66;
                    if (as_bool(logical_eq(get_base1(get_base1(fixed_cutp, q, "fixed_cutp", 1), r, "fixed_cutp", 2), 1))) {
                        current_statement_begin__ = 67;
                        stan::model::assign(beta, 
                                    stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(q), stan::model::nil_index_list())), 
                                    .5, 
                                    "assigning variable beta");
                    } else {
                        current_statement_begin__ = 69;
                        if (as_bool(logical_eq(r, 1))) {
                            current_statement_begin__ = 70;
                            stan::model::assign(beta, 
                                        stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(q), stan::model::nil_index_list())), 
                                        get_base1(beta_init, q, "beta_init", 1), 
                                        "assigning variable beta");
                        } else {
                            current_statement_begin__ = 72;
                            stan::model::assign(beta, 
                                        stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(q), stan::model::nil_index_list())), 
                                        (get_base1(get_base1(beta, (r - 1), "beta", 1), q, "beta", 2) + get_base1(get_base1(raw_beta, r, "raw_beta", 1), q, "raw_beta", 2)), 
                                        "assigning variable beta");
                        }
                    }
                }
                current_statement_begin__ = 77;
                stan::model::assign(raw_delta, 
                            stan::model::cons_list(stan::model::index_uni(q), stan::model::nil_index_list()), 
                            elt_multiply(multiply(sd_delta, get_base1(raw_delta_N01, q, "raw_delta_N01", 1)), get_base1(use_delta, q, "use_delta", 1)), 
                            "assigning variable raw_delta");
                current_statement_begin__ = 78;
                stan::model::assign(mean_raw_delta, 
                            stan::model::cons_list(stan::model::index_uni(q), stan::model::nil_index_list()), 
                            mean(get_base1(raw_delta, q, "raw_delta", 1)), 
                            "assigning variable mean_raw_delta");
                current_statement_begin__ = 79;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 80;
                    stan::model::assign(delta, 
                                stan::model::cons_list(stan::model::index_uni(q), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                (get_base1(get_base1(raw_delta, q, "raw_delta", 1), k, "raw_delta", 2) - get_base1(mean_raw_delta, q, "mean_raw_delta", 1)), 
                                "assigning variable delta");
                }
            }
            current_statement_begin__ = 85;
            stan::model::assign(raw_theta, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        theta_init, 
                        "assigning variable raw_theta");
            current_statement_begin__ = 86;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        Phi_approx(subtract(theta_init, .5)), 
                        "assigning variable theta");
            current_statement_begin__ = 87;
            stan::model::assign(raw_sigma, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        sigma_init, 
                        "assigning variable raw_sigma");
            current_statement_begin__ = 88;
            stan::model::assign(sigma, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        multiply(Phi_approx(sigma_init), .25), 
                        "assigning variable sigma");
            current_statement_begin__ = 91;
            for (int t = 2; t <= T; ++t) {
                current_statement_begin__ = 92;
                stan::model::assign(raw_theta, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            add(get_base1(raw_theta, (t - 1), "raw_theta", 1), multiply(sd_theta_evolve, get_base1(raw_theta_N01, t, "raw_theta_N01", 1))), 
                            "assigning variable raw_theta");
                current_statement_begin__ = 93;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            Phi_approx(subtract(get_base1(raw_theta, t, "raw_theta", 1), .5)), 
                            "assigning variable theta");
                current_statement_begin__ = 94;
                stan::model::assign(raw_sigma, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            add(get_base1(raw_sigma, (t - 1), "raw_sigma", 1), multiply(sd_sigma_evolve, get_base1(raw_sigma_N01, t, "raw_sigma_N01", 1))), 
                            "assigning variable raw_sigma");
                current_statement_begin__ = 95;
                stan::model::assign(sigma, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            multiply(Phi_approx(get_base1(raw_sigma, t, "raw_sigma", 1)), .25), 
                            "assigning variable sigma");
            }
            current_statement_begin__ = 98;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 99;
                stan::model::assign(beta_rr_qq, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(beta, get_base1(rr, n, "rr", 1), "beta", 1), get_base1(qq, n, "qq", 1), "beta", 2), 
                            "assigning variable beta_rr_qq");
                current_statement_begin__ = 100;
                stan::model::assign(delta_qq_kk, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(delta, get_base1(qq, n, "qq", 1), "delta", 1), get_base1(kk, n, "kk", 1), "delta", 2), 
                            "assigning variable delta_qq_kk");
                current_statement_begin__ = 101;
                stan::model::assign(raw_theta_tt_kk, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(raw_theta, get_base1(tt, n, "tt", 1), "raw_theta", 1), get_base1(kk, n, "kk", 1), "raw_theta", 2), 
                            "assigning variable raw_theta_tt_kk");
                current_statement_begin__ = 102;
                stan::model::assign(sigma_tt_kk, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(sigma, get_base1(tt, n, "tt", 1), "sigma", 1), get_base1(kk, n, "kk", 1), "sigma", 2), 
                            "assigning variable sigma_tt_kk");
            }
            current_statement_begin__ = 105;
            for (int n = 1; n <= N_test; ++n) {
                current_statement_begin__ = 106;
                stan::model::assign(beta_rr_qq_test, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(beta, get_base1(rr_test, n, "rr_test", 1), "beta", 1), get_base1(qq_test, n, "qq_test", 1), "beta", 2), 
                            "assigning variable beta_rr_qq_test");
                current_statement_begin__ = 107;
                stan::model::assign(delta_qq_kk_test, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(delta, get_base1(qq_test, n, "qq_test", 1), "delta", 1), get_base1(kk_test, n, "kk_test", 1), "delta", 2), 
                            "assigning variable delta_qq_kk_test");
                current_statement_begin__ = 108;
                stan::model::assign(raw_theta_tt_kk_test, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(raw_theta, get_base1(tt_test, n, "tt_test", 1), "raw_theta", 1), get_base1(kk_test, n, "kk_test", 1), "raw_theta", 2), 
                            "assigning variable raw_theta_tt_kk_test");
                current_statement_begin__ = 109;
                stan::model::assign(sigma_tt_kk_test, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            get_base1(get_base1(sigma, get_base1(tt_test, n, "tt_test", 1), "sigma", 1), get_base1(kk_test, n, "kk_test", 1), "sigma", 2), 
                            "assigning variable sigma_tt_kk_test");
            }
            current_statement_begin__ = 113;
            stan::math::assign(eta, inv_logit(elt_divide(subtract(raw_theta_tt_kk, add(beta_rr_qq, delta_qq_kk)), stan::math::sqrt(add(sigma_tt_kk, square(stan::model::rvalue(alpha, stan::model::cons_list(stan::model::index_multi(qq), stan::model::nil_index_list()), "alpha")))))));
            current_statement_begin__ = 114;
            stan::math::assign(a, multiply(phi, eta));
            current_statement_begin__ = 115;
            stan::math::assign(b, multiply(phi, subtract(1, eta)));
            current_statement_begin__ = 118;
            stan::math::assign(eta_test, inv_logit(elt_divide(subtract(raw_theta_tt_kk_test, add(beta_rr_qq_test, delta_qq_kk_test)), stan::math::sqrt(add(sigma_tt_kk_test, square(stan::model::rvalue(alpha, stan::model::cons_list(stan::model::index_multi(qq_test), stan::model::nil_index_list()), "alpha")))))));
            current_statement_begin__ = 119;
            stan::math::assign(a_test, multiply(phi, eta_test));
            current_statement_begin__ = 120;
            stan::math::assign(b_test, multiply(phi, subtract(1, eta_test)));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 55;
            check_greater_or_equal(function__, "eta", eta, 0);
            check_less_or_equal(function__, "eta", eta, 1);
            current_statement_begin__ = 56;
            check_greater_or_equal(function__, "eta_test", eta_test, 0);
            check_less_or_equal(function__, "eta_test", eta_test, 1);
            current_statement_begin__ = 57;
            check_greater_or_equal(function__, "a", a, 0);
            current_statement_begin__ = 58;
            check_greater_or_equal(function__, "a_test", a_test, 0);
            current_statement_begin__ = 59;
            check_greater_or_equal(function__, "b", b, 0);
            current_statement_begin__ = 60;
            check_greater_or_equal(function__, "b_test", b_test, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t beta_j_1_max__ = Q;
                size_t beta_k_0_max__ = R;
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                        vars__.push_back(beta[k_0__](j_1__));
                    }
                }
                size_t beta_rr_qq_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < beta_rr_qq_j_1_max__; ++j_1__) {
                    vars__.push_back(beta_rr_qq(j_1__));
                }
                size_t beta_rr_qq_test_j_1_max__ = N_test;
                for (size_t j_1__ = 0; j_1__ < beta_rr_qq_test_j_1_max__; ++j_1__) {
                    vars__.push_back(beta_rr_qq_test(j_1__));
                }
                size_t raw_delta_j_1_max__ = K;
                size_t raw_delta_k_0_max__ = Q;
                for (size_t j_1__ = 0; j_1__ < raw_delta_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < raw_delta_k_0_max__; ++k_0__) {
                        vars__.push_back(raw_delta[k_0__](j_1__));
                    }
                }
                size_t mean_raw_delta_j_1_max__ = Q;
                for (size_t j_1__ = 0; j_1__ < mean_raw_delta_j_1_max__; ++j_1__) {
                    vars__.push_back(mean_raw_delta(j_1__));
                }
                size_t delta_j_1_max__ = K;
                size_t delta_k_0_max__ = Q;
                for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < delta_k_0_max__; ++k_0__) {
                        vars__.push_back(delta[k_0__](j_1__));
                    }
                }
                size_t delta_qq_kk_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < delta_qq_kk_j_1_max__; ++j_1__) {
                    vars__.push_back(delta_qq_kk(j_1__));
                }
                size_t delta_qq_kk_test_j_1_max__ = N_test;
                for (size_t j_1__ = 0; j_1__ < delta_qq_kk_test_j_1_max__; ++j_1__) {
                    vars__.push_back(delta_qq_kk_test(j_1__));
                }
                size_t raw_theta_j_1_max__ = K;
                size_t raw_theta_k_0_max__ = T;
                for (size_t j_1__ = 0; j_1__ < raw_theta_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < raw_theta_k_0_max__; ++k_0__) {
                        vars__.push_back(raw_theta[k_0__](j_1__));
                    }
                }
                size_t theta_j_1_max__ = K;
                size_t theta_k_0_max__ = T;
                for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                        vars__.push_back(theta[k_0__](j_1__));
                    }
                }
                size_t raw_theta_tt_kk_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < raw_theta_tt_kk_j_1_max__; ++j_1__) {
                    vars__.push_back(raw_theta_tt_kk(j_1__));
                }
                size_t raw_theta_tt_kk_test_j_1_max__ = N_test;
                for (size_t j_1__ = 0; j_1__ < raw_theta_tt_kk_test_j_1_max__; ++j_1__) {
                    vars__.push_back(raw_theta_tt_kk_test(j_1__));
                }
                size_t raw_sigma_j_1_max__ = K;
                size_t raw_sigma_k_0_max__ = T;
                for (size_t j_1__ = 0; j_1__ < raw_sigma_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < raw_sigma_k_0_max__; ++k_0__) {
                        vars__.push_back(raw_sigma[k_0__](j_1__));
                    }
                }
                size_t sigma_j_1_max__ = K;
                size_t sigma_k_0_max__ = T;
                for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
                        vars__.push_back(sigma[k_0__](j_1__));
                    }
                }
                size_t sigma_tt_kk_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < sigma_tt_kk_j_1_max__; ++j_1__) {
                    vars__.push_back(sigma_tt_kk(j_1__));
                }
                size_t sigma_tt_kk_test_j_1_max__ = N_test;
                for (size_t j_1__ = 0; j_1__ < sigma_tt_kk_test_j_1_max__; ++j_1__) {
                    vars__.push_back(sigma_tt_kk_test(j_1__));
                }
                size_t eta_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                    vars__.push_back(eta(j_1__));
                }
                size_t eta_test_j_1_max__ = N_test;
                for (size_t j_1__ = 0; j_1__ < eta_test_j_1_max__; ++j_1__) {
                    vars__.push_back(eta_test(j_1__));
                }
                size_t a_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
                    vars__.push_back(a(j_1__));
                }
                size_t a_test_j_1_max__ = N_test;
                for (size_t j_1__ = 0; j_1__ < a_test_j_1_max__; ++j_1__) {
                    vars__.push_back(a_test(j_1__));
                }
                size_t b_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                    vars__.push_back(b(j_1__));
                }
                size_t b_test_j_1_max__ = N_test;
                for (size_t j_1__ = 0; j_1__ < b_test_j_1_max__; ++j_1__) {
                    vars__.push_back(b_test(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 147;
            validate_non_negative_index("y_r_test", "N_test", N_test);
            Eigen::Matrix<double, Eigen::Dynamic, 1> y_r_test(N_test);
            stan::math::initialize(y_r_test, DUMMY_VAR__);
            stan::math::fill(y_r_test, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 148;
            for (int n = 1; n <= N_test; ++n) {
                current_statement_begin__ = 149;
                stan::model::assign(y_r_test, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            beta_binomial_rng(get_base1(n_r_test, n, "n_r_test", 1), get_base1(a_test, n, "a_test", 1), get_base1(b_test, n, "b_test", 1), base_rng__), 
                            "assigning variable y_r_test");
            }
            // validate, write generated quantities
            current_statement_begin__ = 147;
            size_t y_r_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < y_r_test_j_1_max__; ++j_1__) {
                vars__.push_back(y_r_test(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    static std::string model_name() {
        return "model_dcpo_kfold";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_j_1_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t raw_beta_j_1_max__ = Q;
        size_t raw_beta_k_0_max__ = R;
        for (size_t j_1__ = 0; j_1__ < raw_beta_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_beta_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "raw_beta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta_init_j_1_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < beta_init_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_init" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t raw_delta_N01_j_1_max__ = K;
        size_t raw_delta_N01_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < raw_delta_N01_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_delta_N01_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "raw_delta_N01" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sd_delta";
        param_names__.push_back(param_name_stream__.str());
        size_t raw_theta_N01_j_1_max__ = K;
        size_t raw_theta_N01_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < raw_theta_N01_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_theta_N01_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "raw_theta_N01" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sd_theta_evolve";
        param_names__.push_back(param_name_stream__.str());
        size_t theta_init_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < theta_init_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_init" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t raw_sigma_N01_j_1_max__ = K;
        size_t raw_sigma_N01_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < raw_sigma_N01_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_sigma_N01_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "raw_sigma_N01" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sd_sigma_evolve";
        param_names__.push_back(param_name_stream__.str());
        size_t sigma_init_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < sigma_init_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_init" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t beta_j_1_max__ = Q;
            size_t beta_k_0_max__ = R;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t beta_rr_qq_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < beta_rr_qq_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_rr_qq" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t beta_rr_qq_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < beta_rr_qq_test_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_rr_qq_test" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t raw_delta_j_1_max__ = K;
            size_t raw_delta_k_0_max__ = Q;
            for (size_t j_1__ = 0; j_1__ < raw_delta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < raw_delta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "raw_delta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t mean_raw_delta_j_1_max__ = Q;
            for (size_t j_1__ = 0; j_1__ < mean_raw_delta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mean_raw_delta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t delta_j_1_max__ = K;
            size_t delta_k_0_max__ = Q;
            for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < delta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "delta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t delta_qq_kk_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < delta_qq_kk_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "delta_qq_kk" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t delta_qq_kk_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < delta_qq_kk_test_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "delta_qq_kk_test" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t raw_theta_j_1_max__ = K;
            size_t raw_theta_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < raw_theta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < raw_theta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "raw_theta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t theta_j_1_max__ = K;
            size_t theta_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "theta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t raw_theta_tt_kk_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < raw_theta_tt_kk_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "raw_theta_tt_kk" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t raw_theta_tt_kk_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < raw_theta_tt_kk_test_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "raw_theta_tt_kk_test" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t raw_sigma_j_1_max__ = K;
            size_t raw_sigma_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < raw_sigma_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < raw_sigma_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "raw_sigma" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sigma_j_1_max__ = K;
            size_t sigma_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sigma" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sigma_tt_kk_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < sigma_tt_kk_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_tt_kk" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t sigma_tt_kk_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < sigma_tt_kk_test_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_tt_kk_test" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < eta_test_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_test" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < a_test_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a_test" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < b_test_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b_test" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t y_r_test_j_1_max__ = N_test;
        for (size_t j_1__ = 0; j_1__ < y_r_test_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_r_test" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_j_1_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t raw_beta_j_1_max__ = Q;
        size_t raw_beta_k_0_max__ = R;
        for (size_t j_1__ = 0; j_1__ < raw_beta_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_beta_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "raw_beta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta_init_j_1_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < beta_init_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_init" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t raw_delta_N01_j_1_max__ = K;
        size_t raw_delta_N01_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < raw_delta_N01_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_delta_N01_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "raw_delta_N01" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sd_delta";
        param_names__.push_back(param_name_stream__.str());
        size_t raw_theta_N01_j_1_max__ = K;
        size_t raw_theta_N01_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < raw_theta_N01_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_theta_N01_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "raw_theta_N01" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sd_theta_evolve";
        param_names__.push_back(param_name_stream__.str());
        size_t theta_init_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < theta_init_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_init" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t raw_sigma_N01_j_1_max__ = K;
        size_t raw_sigma_N01_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < raw_sigma_N01_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < raw_sigma_N01_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "raw_sigma_N01" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sd_sigma_evolve";
        param_names__.push_back(param_name_stream__.str());
        size_t sigma_init_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < sigma_init_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_init" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t beta_j_1_max__ = Q;
            size_t beta_k_0_max__ = R;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t beta_rr_qq_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < beta_rr_qq_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_rr_qq" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t beta_rr_qq_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < beta_rr_qq_test_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_rr_qq_test" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t raw_delta_j_1_max__ = K;
            size_t raw_delta_k_0_max__ = Q;
            for (size_t j_1__ = 0; j_1__ < raw_delta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < raw_delta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "raw_delta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t mean_raw_delta_j_1_max__ = Q;
            for (size_t j_1__ = 0; j_1__ < mean_raw_delta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mean_raw_delta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t delta_j_1_max__ = K;
            size_t delta_k_0_max__ = Q;
            for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < delta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "delta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t delta_qq_kk_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < delta_qq_kk_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "delta_qq_kk" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t delta_qq_kk_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < delta_qq_kk_test_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "delta_qq_kk_test" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t raw_theta_j_1_max__ = K;
            size_t raw_theta_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < raw_theta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < raw_theta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "raw_theta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t theta_j_1_max__ = K;
            size_t theta_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "theta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t raw_theta_tt_kk_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < raw_theta_tt_kk_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "raw_theta_tt_kk" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t raw_theta_tt_kk_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < raw_theta_tt_kk_test_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "raw_theta_tt_kk_test" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t raw_sigma_j_1_max__ = K;
            size_t raw_sigma_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < raw_sigma_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < raw_sigma_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "raw_sigma" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sigma_j_1_max__ = K;
            size_t sigma_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sigma" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sigma_tt_kk_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < sigma_tt_kk_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_tt_kk" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t sigma_tt_kk_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < sigma_tt_kk_test_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_tt_kk_test" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < eta_test_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_test" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < a_test_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a_test" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b_test_j_1_max__ = N_test;
            for (size_t j_1__ = 0; j_1__ < b_test_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b_test" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t y_r_test_j_1_max__ = N_test;
        for (size_t j_1__ = 0; j_1__ < y_r_test_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_r_test" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_dcpo_kfold_namespace::model_dcpo_kfold stan_model;
#endif
