dd_loglik = function(trpars1,pars2,brts,missnumspec)
{
# brts = branching times (positive, from present to past)
# - max(brts) = crown age
# - min(brts) = most recent branching time
# tr is transformed
# - pars1[1] = la = (initial) speciation rate
# - pars1[1] = mu = extinction rate
# - pars1[1] = K = carrying capacity
# - pars2[1] = lx = length of ODE variable x
# - pars2[2] = ddep = diversity-dependent model,mode of diversity-dependence
#  . ddep==1 : linear dependence in speciation rate
#  . ddep==2 : exponential dependence in speciation rate
#  . ddep==3 : linear dependence in extinction rate
#  . ddep==4 : exponential dependence in extinction rate
# missnumspec = number of missing species    

pars1 = trpars1/(1 - trpars1)
abstol = 1e-16
reltol = 1e-10 
brts = -sort(as.numeric(brts),decreasing = TRUE)
if(sum(brts == 0) == 0) { brts[length(brts) + 1] = 0 }
S = length(brts)
if(max(trpars1) > 1 || min(trpars1) < 0 || trpars1[1] <= trpars1[2]) { loglik = -Inf } else
{
    la = pars1[1]
    mu = pars1[2]
    K = pars1[3]
    ddep = pars2[2]
    if(ddep == 1 && ceiling(la/(la - mu) * K) < S) { loglik = -Inf } else
    {
       if(ddep == 1) { lx = min(ceiling(la/(la - mu) * K),round(pars2[1])) } else { lx = round(pars2[1]) }
       probs = rep(0,lx)
       probs[1] = 1 # change if other species at crown age  
       loglik = lgamma(S)
       for(k in 2:S)
       {
          y = lsoda(probs,brts[(k-1):k],dd_loglik_rhs,c(pars1,k,ddep),rtol = reltol,atol = abstol)
          probs = y[2,2:(lx+1)]
          if(k<S)
          {
              if(ddep == 1) { lavec = pmax(rep(0,lx),la - (la-mu)/K * ((0:(lx-1))+k)) } 
              if(ddep == 2) { lavec = pmax(rep(0,lx),la * (((0:(lx-1))+k) + 1)^(-log(la/mu)/log(K+1))) }
              if(ddep == 3 || ddep == 4) { lavec = la }    
              probs = lavec * probs # speciation event
              if(sum(probs) <= 0) { loglik = -Inf } else
              {
                 loglik = loglik + log(sum(probs))
              }
              probs = probs/sum(probs)
          }
       }    
       if(probs[1+missnumspec]<=0) { loglik = -Inf } else
       {        
          loglik = loglik + log(probs[1 + missnumspec]) - log(S - 1) + log(S + missnumspec + 1) - lgamma(S + missnumspec + 2) + lgamma(S + 2) + lgamma(missnumspec + 1)
  
          probs = rep(0,lx)
          probs[1] = 1
          # change if other species at crown age
          k = 2
          t1 = brts[1] 
          t2 = brts[S]
          y = lsoda(probs,c(t1,t2),dd_loglik_rhs,c(pars1,k,ddep),rtol = reltol,atol = abstol);
          probs = y[2,2:(lx+1)]
          aux = (2:(lx+1)) * (3:(lx+2))/6
          logliknorm = log(sum(probs/aux))
          loglik = loglik - logliknorm
       }
    }
}
s1 = sprintf('Parameters: %f %f %f, ',pars1[1],pars1[2],pars1[3])
s2 = sprintf('Loglikelihood: %f',loglik)
cat(s1,s2,"\n")

return(loglik)
}