% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/children.R
\name{DDI-children}
\alias{DDI-children}
\alias{addChildren}
\alias{anyChildren}
\alias{getChildren}
\alias{hasChildren}
\alias{indexChildren}
\alias{removeChildren}
\alias{addContent}
\alias{changeContent}
\alias{removeContent}
\alias{addAttributes}
\alias{anyAttributes}
\alias{changeAttributes}
\alias{hasAttributes}
\alias{removeAttributes}
\title{Add/remove/change one or more children or attributes from a DDI Codebook
attribute.}
\usage{
addChildren(children, to, overwrite = TRUE, ...)

anyChildren(element)

getChildren(xpath, from, ...)

hasChildren(element, name)

indexChildren(element, name)

removeChildren(name, from, overwrite = TRUE, ...)

addContent(content, to, overwrite = TRUE)

changeContent(content, to, overwrite = TRUE)

removeContent(from, overwrite = TRUE)

addAttributes(attrs, to, overwrite = TRUE)

anyAttributes(element)

changeAttributes(attrs, from, overwrite = TRUE)

hasAttributes(element, name)

removeAttributes(name, from, overwrite = TRUE)
}
\arguments{
\item{children}{A standard element of class \code{"DDI"}, or a list of such elements.}

\item{to}{A standard element of class \code{"DDI"}.}

\item{overwrite}{Logical, overwrite the original object in the parent frame.}

\item{...}{Other arguments, mainly for internal use.}

\item{element}{A standard element of class \code{"DDI"}.}

\item{xpath}{Character, a path to a DDI Codebook element.}

\item{from}{A standard element of class \code{"DDI"}.}

\item{name}{Character, name(s) of specific child element / attribute.}

\item{content}{Character, the text content of a DDI element.}

\item{attrs}{A list of specific attribute names and values.}
}
\value{
An invisible standard DDI element. Functions \verb{any*()} and \verb{has*()}
return a logical (vector).
}
\description{
\code{addChildren()} adds one or more children to a standard DDI Codebook element
(see \code{\link{makeElement}}), \code{anyChildren()} checks if an element has any
children at all, \code{hasChildren()} checks if the element has specific children,
\code{indexChildren()} returns the positions of the children among all containing
children, and \code{getChildren()} extracts them. For attributes and content,
there are dedicated functions to \verb{add*()}, \verb{remove*()} and \verb{change*()}.
}
\details{
Although an XML list generally allows for multiple contents, sometimes spread
between the children elements, it is preferable to maintain a single content
(eventually separated with carriage return characters for separate lines).

Arguments are unique, and can be changed by simply referring to their names.

Elements, however, can be repeated. For instance element \code{var} to describe
variables, within the \code{dataDscr} (data description) sub-element in the
\code{codeBook}. There are as many such \code{var} elements as the number of variables
in the dataset, in which case it is not possible to change a specific \code{var}
element by referring to its name. For this purpose, it is useful to extract
the positions of all \code{var} elements to iterate through, which is the purpose
of the function \code{indexChildren()}.

Future versions will allow deep manipulations of child elements using the
\code{xpath} argument.

If more than one children, they should be grouped into a list.
}
\author{
Adrian Dusa
}
